/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

import java.util.Iterator;

public interface EnumeratingIterator<T>
extends Iterator<T> {
    public static <T> EnumeratingIterator<T> castOrWrap(Iterator<T> it) {
        if (it instanceof EnumeratingIterator) {
            return (EnumeratingIterator)it;
        }
        return new WrappingEnumeratingIterator<T>(it);
    }

    public int getIndex();

    public static class WrappingEnumeratingIterator<T>
    implements EnumeratingIterator<T> {
        protected final Iterator<T> it;
        protected int index = -1;

        public WrappingEnumeratingIterator(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            T result = this.it.next();
            ++this.index;
            return result;
        }
    }
}

