/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.projectdata.column;

import ghidra.docking.settings.Settings;
import ghidra.framework.main.datatable.DomainFileInfo;
import ghidra.framework.main.datatable.ProjectDataColumn;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.lang.Endian;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;

public class EndianProjectDataColumn
extends ProjectDataColumn<Endian> {
    private GColumnRenderer<Endian> renderer = new AbstractGhidraColumnRenderer<Endian>(){

        @Override
        protected String getText(Object value) {
            if (value == null) {
                return null;
            }
            return ((Endian)value).getDisplayName();
        }

        public String getFilterString(Endian t, Settings settings) {
            return this.getText(t);
        }
    };

    public String getColumnName() {
        return "Endian";
    }

    public Endian getValue(DomainFileInfo info, Settings settings, ProjectData data, ServiceProvider services) throws IllegalArgumentException {
        String name = info.getMetaDataValue("Endian");
        return Endian.toEndian((String)name);
    }

    public int getColumnPreferredWidth() {
        return 100;
    }

    public boolean isDefaultColumn() {
        return true;
    }

    public int getPriority() {
        return 2;
    }

    public GColumnRenderer<Endian> getColumnRenderer() {
        return this.renderer;
    }
}

