/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.filehandlers;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.widgets.OptionDialog;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBIcons;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.plugins.fsbrowser.FSBRootNode;
import java.awt.Component;
import java.util.List;

public class CloseFSBFileHandler
implements FSBFileHandler {
    public static final String FSB_CLOSE = "FSB Close";
    private FSBFileHandlerContext context;

    @Override
    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    @Override
    public List<DockingAction> createActions() {
        return List.of((DockingAction)new ActionBuilder(FSB_CLOSE, this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getSelectedNode() instanceof FSBRootNode).description("Close").toolBarIcon(FSBIcons.CLOSE).toolBarGroup("ZZZZ").popupMenuIcon(FSBIcons.CLOSE).popupMenuPath(new String[]{"Close"}).popupMenuGroup("ZZZZ").onAction(ac -> {
            FSBNode selectedNode = ac.getSelectedNode();
            if (!(selectedNode instanceof FSBRootNode)) {
                return;
            }
            FSBRootNode node = (FSBRootNode)selectedNode;
            if (node.getParent() == null) {
                if (OptionDialog.showYesNoDialog((Component)ac.getSourceComponent(), (String)"Close File System", (String)"Do you want to close the filesystem browser for %s?".formatted(node.getName())) == 1) {
                    ac.getComponentProvider().componentHidden();
                }
            } else {
                ac.getComponentProvider().runTask(monitor -> node.swapBackPrevModelNodeAndDispose());
            }
        }).build());
    }
}

