/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.format.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.app.util.viewer.field.SpacerFieldFactory;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FieldHeader;
import ghidra.app.util.viewer.format.FieldHeaderLocation;
import ghidra.util.HelpLocation;

public class AddSpacerFieldAction
extends DockingAction {
    private FieldHeader panel;

    public AddSpacerFieldAction(String owner, FieldHeader panel) {
        super("Add Spacer Field", owner, false);
        this.panel = panel;
        this.setPopupMenuData(new MenuData(new String[]{"Add Field", "Spacer"}, "header a"));
        this.setEnabled(true);
        this.setHelpLocation(new HelpLocation("CodeBrowserPlugin", "Add Field"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        return context.getContextObject() instanceof FieldHeaderLocation;
    }

    public void actionPerformed(ActionContext context) {
        FieldHeaderLocation loc = (FieldHeaderLocation)context.getContextObject();
        FieldFormatModel modelAtLocation = loc.getModel();
        this.panel.setTabLock(true);
        modelAtLocation.addFactory(new SpacerFieldFactory(), loc.getRow(), loc.getColumn());
    }
}

