/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PascalStringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.DuplicateNameException;

public class PefDebug
implements StructConverter {
    public static final int SIZEOF = 18;
    private int unknown;
    private int type;
    private int flags;
    private int distance;
    private int nameLength;
    private String name;

    public PefDebug(Memory memory, Address address) throws MemoryAccessException {
        this.unknown = memory.getInt(address);
        this.type = memory.getInt(address.add(4L));
        this.flags = memory.getInt(address.add(8L));
        this.distance = memory.getInt(address.add(12L));
        this.nameLength = memory.getShort(address.add(16L)) & 0xFFFF;
        byte[] stringBytes = new byte[this.nameLength];
        memory.getBytes(address.add(18L), stringBytes);
        this.name = new String(stringBytes);
    }

    public int getUnknown() {
        return this.unknown;
    }

    public int getType() {
        return this.type;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getDistance() {
        return this.distance;
    }

    public int getNameLength() {
        return this.nameLength;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValid() {
        if (this.unknown != 0) {
            return false;
        }
        if (this.type == 0) {
            return false;
        }
        if (this.distance > 65535) {
            return false;
        }
        return this.nameLength > 0 && this.nameLength <= 255;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        String structureName = "PEF_Debug_0x" + Integer.toHexString(this.nameLength);
        StructureDataType structure = new StructureDataType(structureName, 0);
        structure.add((DataType)new DWordDataType(), "unknown", "");
        structure.add((DataType)new DWordDataType(), "type", "");
        structure.add((DataType)new DWordDataType(), "flags", "");
        structure.add((DataType)new DWordDataType(), "distance", "");
        structure.add((DataType)new PascalStringDataType(), this.nameLength + 2, "name", "");
        return structure;
    }
}

