/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf51;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfString;
import ghidra.app.util.bin.format.omf.OmfUtils;
import ghidra.app.util.bin.format.omf.omf51.Omf51RecordTypes;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Omf51LibraryDictionaryRecord
extends OmfRecord {
    private List<List<OmfString>> moduleSymbolMap = new ArrayList<List<OmfString>>();

    public Omf51LibraryDictionaryRecord(BinaryReader reader) throws IOException {
        super(reader);
    }

    @Override
    public void parseData() throws IOException, OmfException {
        ArrayList<OmfString> symbols = new ArrayList<OmfString>();
        while (this.dataReader.getPointerIndex() < this.dataEnd) {
            byte len = this.dataReader.peekNextByte();
            if (len == 0) {
                this.dataReader.readNextByte();
                this.moduleSymbolMap.add(symbols);
                symbols = new ArrayList();
                continue;
            }
            symbols.add(OmfUtils.readString(this.dataReader));
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(Omf51RecordTypes.getName(this.recordType), 0);
        struct.add(BYTE, "type", null);
        struct.add(WORD, "length", null);
        Integer moduleIndex = 0;
        for (List<OmfString> symbols : this.moduleSymbolMap) {
            for (OmfString symbol : symbols) {
                struct.add(symbol.toDataType(), symbol.getDataTypeSize(), "symbol%d".formatted(moduleIndex), null);
            }
            struct.add(BYTE, "terminator%d".formatted(moduleIndex), null);
            Integer n = moduleIndex;
            moduleIndex = moduleIndex + 1;
        }
        struct.add(BYTE, "checksum", null);
        struct.setCategoryPath(new CategoryPath("/OMF"));
        return struct;
    }

    public List<List<OmfString>> getModuleSymbolMap() {
        return this.moduleSymbolMap;
    }
}

