/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfIndex;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfUtils;
import ghidra.app.util.bin.format.omf.omf.OmfRecordTypes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Language;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OmfGroupRecord
extends OmfRecord {
    private OmfIndex groupNameIndex;
    private String groupName;
    private long vma = -1L;
    private GroupSubrecord[] group;

    public OmfGroupRecord(BinaryReader reader) throws IOException {
        super(reader);
    }

    @Override
    public void parseData() throws IOException, OmfException {
        this.groupNameIndex = OmfUtils.readIndex(this.dataReader);
        ArrayList<GroupSubrecord> grouplist = new ArrayList<GroupSubrecord>();
        while (this.dataReader.getPointerIndex() < this.dataEnd) {
            GroupSubrecord subrec = GroupSubrecord.read(this.dataReader);
            grouplist.add(subrec);
        }
        this.group = new GroupSubrecord[grouplist.size()];
        grouplist.toArray(this.group);
    }

    public String getName() {
        return this.groupName;
    }

    public void setStartAddress(long val) {
        this.vma = val;
    }

    public long getStartAddress() {
        return this.vma;
    }

    public int getFrameDatum() {
        return 0;
    }

    public int numSegments() {
        return this.group.length;
    }

    public byte getSegmentComponentType(int i) {
        return this.group[i].componentType;
    }

    public int getSegmentIndex(int i) {
        return this.group[i].segmentIndex.value();
    }

    public Address getAddress(Language language) {
        AddressSpace addrSpace = language.getDefaultSpace();
        return addrSpace.getAddress(this.vma);
    }

    public void resolveNames(List<String> nameList) throws OmfException {
        if (this.groupNameIndex.value() <= 0) {
            throw new OmfException("Cannot have unused group name");
        }
        if (this.groupNameIndex.value() > nameList.size()) {
            throw new OmfException("Group name index out of bounds");
        }
        this.groupName = nameList.get(this.groupNameIndex.value() - 1);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return OmfUtils.toOmfRecordDataType(this, OmfRecordTypes.getName(this.recordType));
    }

    public static class GroupSubrecord {
        private byte componentType;
        private OmfIndex segmentIndex;

        public static GroupSubrecord read(BinaryReader reader) throws IOException {
            GroupSubrecord subrec = new GroupSubrecord();
            subrec.componentType = reader.readNextByte();
            subrec.segmentIndex = OmfUtils.readIndex(reader);
            return subrec;
        }
    }
}

