/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImage;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DyldCacheImageInfo
implements DyldCacheImage,
StructConverter {
    private long address;
    private long modTime;
    private long inode;
    private int pathFileOffset;
    private int pad;
    private String path;

    public DyldCacheImageInfo(BinaryReader reader) throws IOException {
        this.address = reader.readNextLong();
        this.modTime = reader.readNextLong();
        this.inode = reader.readNextLong();
        this.pathFileOffset = reader.readNextInt();
        this.pad = reader.readNextInt();
        this.path = reader.readAsciiString(this.pathFileOffset);
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_image_info", 0);
        struct.add(QWORD, "address", "");
        struct.add(QWORD, "modTime", "");
        struct.add(QWORD, "inode", "");
        struct.add(DWORD, "pathFileOffset", "");
        struct.add(DWORD, "pad", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

