/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.elf.info.ElfInfoItem;
import ghidra.app.util.bin.format.golang.GoConstants;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class GoBuildId {
    private static final byte[] GO_BUILDID_MAGIC = "\u00ff Go build ID: \"".getBytes(StandardCharsets.ISO_8859_1);
    private static final int BUILDID_STR_LEN = 83;
    private final String buildId;

    public static ElfInfoItem.ItemWithAddress<GoBuildId> findBuildId(Program program) {
        MemoryBlock txtBlock = GoRttiMapper.getGoSection(program, "text");
        ElfInfoItem.ItemWithAddress<GoBuildId> wrappedItem = GoBuildId.readItemFromSection(program, txtBlock, GoBuildId::read);
        return wrappedItem;
    }

    public static GoBuildId read(BinaryReader br, Program program_notused) {
        try {
            byte[] magic = br.readNextByteArray(GO_BUILDID_MAGIC.length);
            if (!Arrays.equals(magic, GO_BUILDID_MAGIC)) {
                return null;
            }
            String buildIdStr = br.readNextAsciiString(83);
            return new GoBuildId(buildIdStr);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static GoBuildId read(InputStream is) {
        byte[] buffer = new byte[GO_BUILDID_MAGIC.length + 83];
        try {
            int bytesRead = is.read(buffer);
            if (bytesRead == buffer.length) {
                ByteArrayProvider bap = new ByteArrayProvider(buffer);
                return GoBuildId.read(new BinaryReader(bap, false), null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public GoBuildId(String buildId) {
        this.buildId = buildId;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public void markupProgram(Program program, Address address) {
        program.getOptions("Program Information").setString("Golang BuildId", this.getBuildId());
        try {
            StructureDataType struct = this.toStructure((DataTypeManager)program.getDataTypeManager());
            if (struct != null) {
                DataUtilities.createData((Program)program, (Address)address, (DataType)struct, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_DEFAULT_CONFLICT_DATA);
            }
        }
        catch (CodeUnitInsertionException e) {
            Msg.error((Object)this, (Object)"Failed to markup GoBuildId at %s: %s".formatted(address, this));
        }
    }

    private StructureDataType toStructure(DataTypeManager dtm) {
        StructureDataType result = new StructureDataType(GoConstants.GOLANG_CATEGORYPATH, "GoBuildId", 0, dtm);
        result.add((DataType)StringDataType.dataType, GO_BUILDID_MAGIC.length, "magic", null);
        result.add((DataType)StringDataType.dataType, 83, "buildId", null);
        return result;
    }

    static <T> ElfInfoItem.ItemWithAddress<T> readItemFromSection(Program program, MemoryBlock memBlock, ElfInfoItem.ReaderFunc<T> readFunc) {
        if (memBlock != null) {
            ElfInfoItem.ItemWithAddress<T> itemWithAddress;
            block9: {
                MemoryByteProvider bp = MemoryByteProvider.createMemoryBlockByteProvider(program.getMemory(), memBlock);
                try {
                    BinaryReader br = new BinaryReader(bp, !program.getMemory().isBigEndian());
                    T item = readFunc.read(br, program);
                    ElfInfoItem.ItemWithAddress<T> itemWithAddress2 = itemWithAddress = item != null ? new ElfInfoItem.ItemWithAddress<T>(item, memBlock.getStart()) : null;
                    if (bp == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (bp != null) {
                            try {
                                bp.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Msg.warn(GoBuildId.class, (Object)"Unable to read GoBuildId in section: %s".formatted(memBlock.getName()), (Throwable)e);
                    }
                }
                bp.close();
            }
            return itemWithAddress;
        }
        return null;
    }
}

