/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProviderInputStream;
import ghidra.app.util.bin.EmptyByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public interface ByteProvider
extends Closeable {
    public static final ByteProvider EMPTY_BYTEPROVIDER = new EmptyByteProvider();

    default public FSRL getFSRL() {
        File f = this.getFile();
        return f != null ? FileSystemService.getInstance().getLocalFSRL(f) : null;
    }

    public File getFile();

    public String getName();

    public String getAbsolutePath();

    public long length() throws IOException;

    default public boolean isEmpty() {
        try {
            return this.length() == 0L;
        }
        catch (IOException e) {
            return true;
        }
    }

    public boolean isValidIndex(long var1);

    @Override
    public void close() throws IOException;

    public byte readByte(long var1) throws IOException;

    public byte[] readBytes(long var1, long var3) throws IOException;

    default public InputStream getInputStream(long index) throws IOException {
        if (index < 0L || index > this.length()) {
            throw new IOException("Invalid start position: " + index);
        }
        return new ByteProviderInputStream(this, index);
    }
}

