/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.builder.ActionBuilder;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.data.DataSettingsDialog;
import ghidra.app.plugin.core.data.DataTypeSettingsDialog;
import ghidra.app.plugin.core.strings.ViewStringsContext;
import ghidra.app.plugin.core.strings.ViewStringsProvider;
import ghidra.app.services.GoToService;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import ghidra.util.task.SwingUpdateManager;
import javax.swing.Icon;
import resources.Icons;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Defined String Table", description="Displays all defined strings in the current program.", servicesRequired={GoToService.class})
public class ViewStringsPlugin
extends ProgramPlugin
implements DomainObjectListener {
    private static Icon REFRESH_ICON = Icons.REFRESH_ICON;
    private static Icon REFRESH_NOT_NEEDED_ICON = ResourceManager.getDisabledIcon((Icon)Icons.REFRESH_ICON, (int)60);
    private DockingAction refreshAction;
    private SelectionNavigationAction linkNavigationAction;
    private ViewStringsProvider provider;
    private SwingUpdateManager reloadUpdateMgr;

    public ViewStringsPlugin(PluginTool tool) {
        super(tool);
    }

    void doReload() {
        this.provider.reload();
    }

    protected void init() {
        super.init();
        this.provider = new ViewStringsProvider(this);
        this.reloadUpdateMgr = new SwingUpdateManager(100, 60000, this::doReload);
        this.createActions();
    }

    private void createActions() {
        this.refreshAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Refresh Strings", this.getName()).toolBarIcon(REFRESH_NOT_NEEDED_ICON)).description("<html>Push at any time to refresh the current table of strings.<br>This button is highlighted when the data <i>may</i> be stale.<br>")).enabledWhen(ac -> this.getCurrentProgram() != null)).onAction(ac -> {
            this.refreshAction.getToolBarData().setIcon(REFRESH_NOT_NEEDED_ICON);
            this.reload();
        })).helpLocation(new HelpLocation("ViewStringsPlugin", "Refresh"))).buildAndInstallLocal((ComponentProvider)this.provider);
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)new MakeProgramSelectionAction(this, this.provider.getTable()));
        this.linkNavigationAction = new SelectionNavigationAction(this, this.provider.getTable());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.linkNavigationAction);
        new ActionBuilder("Data Settings", this.getName()).withContext(ViewStringsContext.class).popupMenuPath(new String[]{"Settings..."}).popupMenuGroup("R").helpLocation(new HelpLocation("DataPlugin", "Data_Settings")).sharedKeyBinding().enabledWhen(vsac -> vsac.getCount() > 0).onAction(vsac -> {
            try {
                DataSettingsDialog dialog = vsac.getCount() == 1 ? new DataSettingsDialog(vsac.getSelectedData()) : new DataSettingsDialog(vsac.getProgram(), vsac.getProgramSelection());
                this.tool.showDialog((DialogComponentProvider)dialog);
                dialog.dispose();
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
        }).buildAndInstallLocal((ComponentProvider)this.provider);
        new ActionBuilder("Default Settings", this.getName()).withContext(ViewStringsContext.class).popupMenuPath(new String[]{"Default Settings..."}).popupMenuGroup("R").helpLocation(new HelpLocation("DataPlugin", "Default_Settings")).sharedKeyBinding().enabledWhen(vsac -> {
            if (vsac.getCount() != 1) {
                return false;
            }
            Data data = vsac.getSelectedData();
            return data != null && data.getDataType().getSettingsDefinitions().length != 0;
        }).onAction(vsac -> {
            Data data = vsac.getSelectedData();
            if (data == null) {
                return;
            }
            DataType dt = data.getDataType();
            DataTypeSettingsDialog dialog = new DataTypeSettingsDialog(dt, dt.getSettingsDefinitions());
            this.tool.showDialog((DialogComponentProvider)dialog);
            dialog.dispose();
        }).buildAndInstallLocal((ComponentProvider)this.provider);
    }

    public void dispose() {
        this.reloadUpdateMgr.dispose();
        this.provider.dispose();
        super.dispose();
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener((DomainObjectListener)this);
        this.provider.setProgram(null);
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener((DomainObjectListener)this);
        this.provider.setProgram(program);
    }

    @Override
    protected void locationChanged(ProgramLocation loc) {
        if (this.linkNavigationAction.isSelected() && loc != null) {
            this.provider.setProgram(loc.getProgram());
            this.provider.showProgramLocation(loc);
        }
    }

    private void markDataAsStale() {
        this.provider.getComponent().repaint();
        this.refreshAction.getToolBarData().setIcon(REFRESH_ICON);
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.contains(new EventType[]{DomainObjectEvent.RESTORED, ProgramEvent.MEMORY_BLOCK_MOVED, ProgramEvent.MEMORY_BLOCK_REMOVED, ProgramEvent.DATA_TYPE_CHANGED})) {
            this.markDataAsStale();
            return;
        }
        block4: for (int i = 0; i < ev.numRecords(); ++i) {
            DomainObjectChangeRecord doRecord = ev.getChangeRecord(i);
            Object newValue = doRecord.getNewValue();
            EventType eventType = doRecord.getEventType();
            if (!(eventType instanceof ProgramEvent)) continue;
            ProgramEvent type = (ProgramEvent)eventType;
            switch (type) {
                case CODE_REMOVED: {
                    ProgramChangeRecord pcRec = (ProgramChangeRecord)doRecord;
                    this.provider.remove(pcRec.getStart(), pcRec.getEnd());
                    continue block4;
                }
                case CODE_ADDED: {
                    if (!(newValue instanceof Data)) continue block4;
                    this.provider.add((Data)newValue);
                    continue block4;
                }
            }
        }
        if (ev.contains((EventType)ProgramEvent.DATA_TYPE_SETTING_CHANGED)) {
            this.provider.getComponent().repaint();
        }
    }

    private void reload() {
        this.reloadUpdateMgr.update();
    }
}

