/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.interpreter;

import generic.theme.GColor;
import ghidra.app.plugin.core.interpreter.AnsiParser;
import ghidra.util.ColorUtils;
import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class AnsiRenderer {
    private static final Color[] BASIC_COLORS = new Color[]{new GColor("color.fg.plugin.interpreter.renderer.color.standard.1"), new GColor("color.fg.plugin.interpreter.renderer.color.standard.2"), new GColor("color.fg.plugin.interpreter.renderer.color.standard.3"), new GColor("color.fg.plugin.interpreter.renderer.color.standard.4"), new GColor("color.fg.plugin.interpreter.renderer.color.standard.5"), new GColor("color.fg.plugin.interpreter.renderer.color.standard.6"), new GColor("color.fg.plugin.interpreter.renderer.color.standard.7"), new GColor("color.fg.plugin.interpreter.renderer.color.standard.8"), new GColor("color.fg.plugin.interpreter.renderer.color.intense.1"), new GColor("color.fg.plugin.interpreter.renderer.color.intense.2"), new GColor("color.fg.plugin.interpreter.renderer.color.intense.3"), new GColor("color.fg.plugin.interpreter.renderer.color.intense.4"), new GColor("color.fg.plugin.interpreter.renderer.color.intense.5"), new GColor("color.fg.plugin.interpreter.renderer.color.intense.6"), new GColor("color.fg.plugin.interpreter.renderer.color.intense.7"), new GColor("color.fg.plugin.interpreter.renderer.color.intense.8")};
    private static final int[] CUBE_STEPS = new int[]{0, 95, 135, 175, 215, 255};
    private final ParserHandler handler = new ParserHandler();
    private final AnsiParser parser = new AnsiParser(this.handler);
    private AttributeSet defaultAttributes = null;

    public void renderString(StyledDocument document, String text, MutableAttributeSet attributes) throws BadLocationException {
        this.handler.document = document;
        this.handler.attributes = attributes;
        if (this.defaultAttributes == null) {
            this.defaultAttributes = attributes.copyAttributes();
        }
        this.parser.processString(text);
    }

    private class ParserHandler
    implements AnsiParser.AnsiParserHandler {
        public StyledDocument document;
        public MutableAttributeSet attributes;

        private ParserHandler() {
        }

        @Override
        public void handleString(String text) throws BadLocationException {
            this.document.insertString(this.document.getLength(), text, this.attributes);
        }

        private Color get256Color(int v) {
            if (v < 16) {
                return BASIC_COLORS[v];
            }
            if (v < 232) {
                int b = (v -= 16) % 6;
                int g = v / 6 % 6;
                int r = v / 36 % 6;
                return ColorUtils.getColor((int)CUBE_STEPS[r], (int)CUBE_STEPS[g], (int)CUBE_STEPS[b]);
            }
            if (v < 256) {
                int gray = (v -= 232) * 10 + 8;
                return ColorUtils.getColor((int)gray, (int)gray, (int)gray);
            }
            return BASIC_COLORS[0];
        }

        private int handleSGRAttribute(String[] bits, int pos) throws NumberFormatException {
            int code = Integer.parseInt(bits[pos]);
            if (code >= 30 && code < 50) {
                Object attributeName = code < 40 ? StyleConstants.Foreground : StyleConstants.Background;
                int colorCode = code % 10;
                if (colorCode < 8) {
                    this.attributes.addAttribute(attributeName, BASIC_COLORS[colorCode]);
                    return 1;
                }
                if (colorCode == 8) {
                    if (pos + 1 >= bits.length) {
                        return 1;
                    }
                    int colorType = Integer.parseInt(bits[pos + 1]);
                    if (colorType == 5 && pos + 2 < bits.length) {
                        int color = Integer.parseInt(bits[pos + 2]);
                        this.attributes.addAttribute(attributeName, this.get256Color(color));
                        return 3;
                    }
                    if (colorType == 2 && pos + 4 < bits.length) {
                        int r = Integer.parseInt(bits[pos + 2]);
                        int g = Integer.parseInt(bits[pos + 3]);
                        int b = Integer.parseInt(bits[pos + 4]);
                        this.attributes.addAttribute(attributeName, ColorUtils.getColor((int)r, (int)g, (int)b));
                        return 5;
                    }
                    return 1;
                }
                if (colorCode == 9) {
                    this.attributes.removeAttribute(attributeName);
                    return 1;
                }
            }
            switch (code) {
                case 0: {
                    this.attributes.removeAttributes(this.attributes);
                    this.attributes.addAttributes(AnsiRenderer.this.defaultAttributes);
                    break;
                }
                case 1: {
                    StyleConstants.setBold(this.attributes, true);
                    break;
                }
                case 2: {
                    StyleConstants.setBold(this.attributes, false);
                    break;
                }
                case 3: {
                    StyleConstants.setItalic(this.attributes, true);
                    break;
                }
                case 4: {
                    StyleConstants.setUnderline(this.attributes, true);
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    StyleConstants.setStrikeThrough(this.attributes, true);
                    break;
                }
                case 20: {
                    break;
                }
                case 21: {
                    StyleConstants.setUnderline(this.attributes, true);
                    break;
                }
                case 22: {
                    StyleConstants.setBold(this.attributes, false);
                    break;
                }
                case 23: {
                    StyleConstants.setItalic(this.attributes, false);
                    break;
                }
                case 24: {
                    StyleConstants.setUnderline(this.attributes, false);
                    break;
                }
                case 25: {
                    break;
                }
                case 26: {
                    break;
                }
                case 27: {
                    break;
                }
                case 28: {
                    break;
                }
                case 29: {
                    StyleConstants.setStrikeThrough(this.attributes, false);
                }
            }
            return 1;
        }

        @Override
        public void handleCSI(String param, String inter, String finalChar) throws BadLocationException {
            if (finalChar.equals("m")) {
                if (param.isEmpty()) {
                    param = "0";
                }
                String[] bits = param.split("[:;]");
                int pos = 0;
                while (pos < bits.length) {
                    try {
                        int advance = this.handleSGRAttribute(bits, pos);
                        pos += advance;
                    }
                    catch (NumberFormatException e) {
                        ++pos;
                    }
                }
            }
        }

        @Override
        public void handleOSC(String param) throws BadLocationException {
        }
    }
}

