/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datawindow;

import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.widgets.button.GRadioButton;
import docking.widgets.checkbox.GHtmlCheckBox;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.filter.FilterListener;
import docking.widgets.filter.FilterTextField;
import docking.widgets.label.GLabel;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.datawindow.DataWindowPlugin;
import ghidra.util.HelpLocation;
import ghidra.util.task.SwingUpdateManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.apache.commons.lang3.StringUtils;

class DataWindowFilterDialog
extends DialogComponentProvider {
    private JPanel mainPanel;
    private List<JCheckBox> checkboxes = new ArrayList<JCheckBox>();
    private JPanel checkboxPanel;
    private JRadioButton enabledButton;
    private JRadioButton disabledButton;
    private GhidraComboBox<DataWindowPlugin.Coverage> coverageCombo;
    private JButton selectAllButton;
    private JButton selectNoneButton;
    private FilterTextField filterField;
    private List<String> filteredList = new ArrayList<String>();
    private SortedMap<String, Boolean> typeEnabledMap;
    private boolean isFilterEnabled = true;
    private SwingUpdateManager updateManager = new SwingUpdateManager(250, 1000, () -> this.filterCheckboxes());
    private KeyListener listener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10 && e.getModifiersEx() == 0) {
                e.consume();
                DataWindowFilterDialog.this.okCallback();
            }
        }
    };
    private ItemListener itemListener = e -> {
        JCheckBox checkBox = (JCheckBox)e.getItem();
        this.typeEnabledMap.put(checkBox.getName(), checkBox.isSelected());
    };
    private FilterListener filterListener = new FilterActionFilterListener();
    private DataWindowPlugin plugin;

    DataWindowFilterDialog(DataWindowPlugin plugin) {
        super("Set Data Type Filter");
        this.plugin = plugin;
        this.typeEnabledMap = new TreeMap<String, Boolean>(plugin.getTypeMap());
        this.addWorkPanel(this.create());
        this.addOKButton();
        this.addCancelButton();
        this.setSelectionEnabled(plugin.getSelection() != null);
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Filter_Data_Types"));
        this.setPreferredSize(360, 730);
    }

    private JComponent create() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 3));
        JPanel enablePanel = new JPanel(new FlowLayout(0));
        ButtonGroup group = new ButtonGroup();
        this.enabledButton = new GRadioButton("Enabled", true);
        this.enabledButton.addKeyListener(this.listener);
        enablePanel.add(this.enabledButton);
        group.add(this.enabledButton);
        this.disabledButton = new GRadioButton("Disabled", false);
        this.disabledButton.addKeyListener(this.listener);
        enablePanel.add(this.disabledButton);
        group.add(this.disabledButton);
        enablePanel.setBorder(BorderFactory.createTitledBorder("Filter State"));
        this.mainPanel.add(enablePanel);
        this.enabledButton.addChangeListener(e -> {
            boolean enabled;
            this.isFilterEnabled = enabled = this.enabledButton.isSelected();
            for (JCheckBox cb : this.checkboxes) {
                cb.setEnabled(enabled);
            }
            this.selectAllButton.setEnabled(enabled);
            this.selectNoneButton.setEnabled(enabled);
            this.coverageCombo.setEnabled(enabled);
            this.filterField.setEnabled(enabled);
        });
        JPanel limitPanel = new JPanel(new FlowLayout(0));
        this.coverageCombo = new GhidraComboBox();
        this.coverageCombo.addKeyListener(this.listener);
        this.coverageCombo.setModel(new DefaultComboBoxModel<DataWindowPlugin.Coverage>(DataWindowPlugin.Coverage.values()));
        limitPanel.add((Component)this.coverageCombo);
        limitPanel.setBorder(BorderFactory.createTitledBorder("Limit Data To"));
        this.mainPanel.add(limitPanel);
        JPanel typesPanel = new JPanel(new BorderLayout());
        JPanel typeButtonPanel = new JPanel(new GridLayout(1, 2, 5, 0));
        this.selectAllButton = new JButton("Check All");
        this.selectAllButton.setMnemonic('A');
        this.selectAllButton.addActionListener(evt -> {
            for (JCheckBox element : this.checkboxes) {
                element.setSelected(true);
            }
        });
        typeButtonPanel.add(this.selectAllButton);
        this.selectNoneButton = new JButton("Check None");
        this.selectNoneButton.setMnemonic('N');
        this.selectNoneButton.addActionListener(evt -> {
            for (JCheckBox element : this.checkboxes) {
                element.setSelected(false);
            }
        });
        typeButtonPanel.add(this.selectNoneButton);
        this.checkboxPanel = new JPanel();
        this.checkboxPanel.setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
        this.checkboxPanel.setLayout(new BoxLayout(this.checkboxPanel, 1));
        this.buildCheckBoxList();
        JScrollPane scroller = new JScrollPane(this.checkboxPanel);
        typesPanel.add((Component)scroller, "Center");
        typesPanel.setBorder(BorderFactory.createTitledBorder("Enabled Data Types"));
        typesPanel.add((Component)typeButtonPanel, "South");
        this.mainPanel.add(typesPanel);
        this.filterField = new FilterTextField((Component)this.checkboxPanel);
        this.filterField.addFilterListener(this.filterListener);
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new BoxLayout(filterPanel, 2));
        filterPanel.add((Component)new GLabel("Filter:"));
        filterPanel.add(Box.createHorizontalStrut(10));
        filterPanel.add((Component)this.filterField);
        filterPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.mainPanel.add(filterPanel);
        return this.mainPanel;
    }

    private void buildCheckBoxList() {
        this.checkboxPanel.removeAll();
        this.checkboxes.clear();
        if (!this.filteredList.isEmpty()) {
            String filteredText = this.getFilterText();
            for (String type : this.filteredList) {
                Boolean enabled = (Boolean)this.typeEnabledMap.get(type);
                StringBuilder html = new StringBuilder(type);
                int firstIndex = StringUtils.indexOfIgnoreCase((CharSequence)type, (CharSequence)filteredText, (int)0);
                int lastIndex = firstIndex + filteredText.length();
                html.insert(lastIndex, "</b>");
                html.insert(firstIndex, "<b>");
                html.insert(0, "<html>");
                this.createCheckBox(html.toString(), type, enabled);
            }
        } else if (StringUtils.isBlank((CharSequence)this.getFilterText())) {
            for (String type : this.typeEnabledMap.keySet()) {
                Boolean enabled = (Boolean)this.typeEnabledMap.get(type);
                this.createCheckBox(type, type, enabled);
            }
        }
        this.repaint();
    }

    private String getFilterText() {
        if (this.filterField != null) {
            return this.filterField.getText().trim();
        }
        return null;
    }

    private void repaint() {
        this.checkboxPanel.invalidate();
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }

    private void createCheckBox(String html, String typeName, Boolean enabled) {
        GHtmlCheckBox newCb = new GHtmlCheckBox(html, enabled.booleanValue());
        newCb.setName(typeName);
        newCb.addKeyListener(this.listener);
        newCb.addItemListener(this.itemListener);
        DockingUtils.setTransparent((JComponent)newCb);
        this.checkboxes.add((JCheckBox)newCb);
        this.checkboxPanel.add((Component)newCb);
    }

    private void filterCheckboxes() {
        ArrayList<String> checkboxNameList = new ArrayList<String>();
        String filterText = this.getFilterText();
        if (!StringUtils.isBlank((CharSequence)filterText)) {
            Set<Map.Entry<String, Boolean>> entrySet = this.typeEnabledMap.entrySet();
            for (Map.Entry<String, Boolean> entry : entrySet) {
                String checkboxName = entry.getKey();
                if (!StringUtils.containsIgnoreCase((CharSequence)checkboxName, (CharSequence)filterText)) continue;
                checkboxNameList.add(checkboxName);
            }
        }
        this.filteredList = checkboxNameList;
        this.buildCheckBoxList();
    }

    boolean isFilterEnabled() {
        return this.isFilterEnabled;
    }

    public void okCallback() {
        if (!this.isFilterEnabled) {
            this.plugin.setFilterEnabled(false);
        } else {
            DataWindowPlugin.Coverage coverage = (DataWindowPlugin.Coverage)((Object)this.coverageCombo.getSelectedItem());
            this.plugin.setFilter(this.typeEnabledMap, coverage);
        }
        this.typeEnabledMap.clear();
        this.close();
    }

    public void cancelCallback() {
        this.typeEnabledMap.clear();
        this.close();
    }

    void setSelectionEnabled(boolean enableSelection) {
        if (enableSelection) {
            this.coverageCombo.setModel(new DefaultComboBoxModel<DataWindowPlugin.Coverage>(DataWindowPlugin.Coverage.values()));
        } else {
            this.coverageCombo.setModel(new DefaultComboBoxModel<DataWindowPlugin.Coverage>(new DataWindowPlugin.Coverage[]{DataWindowPlugin.Coverage.PROGRAM, DataWindowPlugin.Coverage.VIEW}));
        }
    }

    void setTypeEnabled(String type, boolean b) {
        for (JCheckBox cb : this.checkboxes) {
            String name = cb.getName();
            if (!name.equals(type)) continue;
            cb.setSelected(b);
        }
    }

    void setFilterEnabled(boolean b) {
        if (b) {
            this.enabledButton.setSelected(true);
        } else {
            this.disabledButton.setSelected(true);
        }
    }

    private class FilterActionFilterListener
    implements FilterListener {
        private FilterActionFilterListener() {
        }

        public void filterChanged(String text) {
            DataWindowFilterDialog.this.filterCheckboxes();
            DataWindowFilterDialog.this.updateManager.updateLater();
        }
    }
}

