/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.services.DataTypeManagerService;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;

public class EditComponentAction
extends CompositeEditorTableAction {
    public static final String ACTION_NAME = "Edit Component";
    private static final String GROUP_NAME = "2_BASIC_EDITOR_ACTION";
    private static final String DESCRIPTION = "Edit the selected component";
    private static String[] POPUP_PATH = new String[]{"Edit Component"};
    private static String[] MENU_PATH = new String[]{"Edit Component"};
    private DataTypeManagerService dtmService;

    public EditComponentAction(CompositeEditorProvider<?, ?> provider) {
        super(provider, ACTION_NAME, GROUP_NAME, POPUP_PATH, MENU_PATH, null);
        this.dtmService = provider.dtmService;
        this.setDescription(DESCRIPTION);
    }

    public void actionPerformed(ActionContext context) {
        if (!this.isEnabledForContext(context)) {
            return;
        }
        int row = this.model.getRow();
        if (row >= this.model.getNumComponents()) {
            this.requestTableFocus();
            return;
        }
        if (!this.model.isEditComponentAllowed()) {
            this.model.setStatus("Can only edit a structure, union, enum or function-definition.");
            return;
        }
        DataTypeComponent comp = this.model.getComponent(row);
        DataType clickedType = comp.getDataType();
        DataType dt = DataTypeUtils.getBaseDataType(clickedType);
        this.edit(dt, clickedType.getName());
        this.requestTableFocus();
    }

    private void edit(DataType dt, String clickedName) {
        DataTypeManager dtm = this.model.getOriginalDataTypeManager();
        if (dtm == null) {
            this.model.setStatus("No Data Type Manager found for '" + clickedName + "'");
            return;
        }
        DataType actualType = dtm.getDataType(dt.getDataTypePath());
        if (actualType == null) {
            this.model.setStatus("Can't edit '" + dt.getDisplayName() + "' - type not found.");
            return;
        }
        this.dtmService.edit(actualType);
    }

    public boolean isEnabledForContext(ActionContext context) {
        return !this.hasIncompleteFieldEntry() && this.model.isEditComponentAllowed();
    }
}

