/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.bookmark;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.app.plugin.core.bookmark.BookmarkPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.util.MarkerLocation;
import ghidra.util.HelpLocation;

class DeleteBookmarkAction
extends DockingAction {
    BookmarkPlugin plugin;
    Bookmark bookmark;
    Address popupLocation;

    DeleteBookmarkAction(BookmarkPlugin plugin, Bookmark bookmark, boolean isOffcut) {
        super("Delete " + bookmark.getTypeString() + " Bookmark", plugin.getName(), false);
        this.plugin = plugin;
        this.bookmark = bookmark;
        this.setDescription("Delete " + bookmark.getTypeString() + " bookmark.");
        Object name = bookmark.getTypeString();
        String comment = bookmark.getComment();
        if (comment != null && comment.length() != 0) {
            name = (String)name + ": " + comment;
        }
        if (isOffcut) {
            name = "(@" + String.valueOf(bookmark.getAddress()) + ") " + (String)name;
        }
        this.setPopupMenuData(new MenuData(new String[]{"Delete Bookmark", name}, "Bookmark"));
        this.setHelpLocation(new HelpLocation("BookmarkPlugin", "Delete_Bookmark"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        return context.getContextObject() instanceof MarkerLocation;
    }

    public void actionPerformed(ActionContext context) {
        if (this.isEnabled()) {
            this.plugin.deleteBookmark(this.bookmark);
        }
    }
}

