/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import ghidra.app.merge.listing.AbstractListingMerger;
import ghidra.app.merge.listing.ListingMergeManager;
import ghidra.app.merge.listing.VerticalChoicesPanel;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.app.merge.util.ConflictUtility;
import ghidra.app.merge.util.MergeUtilities;
import ghidra.program.database.properties.GenericSaveable;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.PropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.program.util.MultiAddressIterator;
import ghidra.program.util.ProgramConflictException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class UserDefinedPropertyMerger
extends AbstractListingMerger {
    static final String USER_DEFINED_PHASE = "User Defined Properties";
    private PropertyMapManager latestPMM;
    private PropertyMapManager myPMM;
    private PropertyMapManager originalPMM;
    private String propertyName;
    private AddressSetView myDetailSet;
    private String[] propNames;
    private AddressSet[] conflictSets;
    private AddressSet conflictSet;
    private VerticalChoicesPanel conflictPanel;
    private int[] sameOption;
    private int propertyIndex = 0;

    UserDefinedPropertyMerger(ListingMergeManager listingMergeMgr) {
        super(listingMergeMgr);
    }

    @Override
    public void init() {
        super.init();
        this.latestPMM = this.latestPgm.getUsrPropertyManager();
        this.myPMM = this.myPgm.getUsrPropertyManager();
        this.originalPMM = this.originalPgm.getUsrPropertyManager();
        this.conflictSet = new AddressSet();
    }

    @Override
    public String getConflictType() {
        return "User Defined Property";
    }

    @Override
    public void autoMerge(int progressMin, int progressMax, TaskMonitor monitor) throws ProgramConflictException, MemoryAccessException, CancelledException {
        int i;
        this.initializeAutoMerge("Auto-merging User Defined Properties and determining conflicts.", progressMin, progressMax, monitor);
        AddressSetView latestDetailSet = this.listingMergeMgr.diffOriginalLatest.getTypeDiffs(8192, this.listingMergeMgr.latestSet, monitor);
        this.myDetailSet = this.listingMergeMgr.diffOriginalMy.getTypeDiffs(8192, this.listingMergeMgr.mySet, monitor);
        AddressSet tmpAutoSet = new AddressSet();
        AddressSet overlapSet = new AddressSet();
        MergeUtilities.adjustSets(latestDetailSet, this.myDetailSet, tmpAutoSet, overlapSet);
        this.listingMergeMgr.mergeMy.mergeProperties((AddressSetView)tmpAutoSet, monitor);
        this.propNames = this.getPropertyNames();
        int numProps = this.propNames.length;
        this.totalChanges = numProps;
        this.changeNum = 0L;
        this.conflictSets = new AddressSet[numProps];
        this.sameOption = new int[numProps];
        for (i = 0; i < numProps; ++i) {
            this.conflictSets[i] = new AddressSet();
            this.sameOption[i] = 0;
        }
        for (i = 0; i < this.propNames.length; ++i) {
            String msg;
            this.propertyIndex = i;
            PropertyMap latestMap = this.latestPMM.getPropertyMap(this.propNames[i]);
            PropertyMap myMap = this.myPMM.getPropertyMap(this.propNames[i]);
            PropertyMap originalMap = this.originalPMM.getPropertyMap(this.propNames[i]);
            if (this.isUnsupportedMap(latestMap) || this.isUnsupportedMap(myMap)) {
                msg = "Encountered unsupported property: " + this.propNames[i] + "\nYour Ghidra may be missing the java class for this property.\n\nAny changes you have made to this property type will be lost\nif you check-in your changes.";
                Msg.showError((Object)this, (Component)this.listingMergePanel, (String)"User Defined Property Merge Error", (Object)msg);
                continue;
            }
            if (!this.samePropertyTypes(latestMap, myMap)) {
                msg = "Latest and Checked Out program versions do not have the same type for '" + this.propNames[i] + "' property.";
                Msg.showError((Object)this, (Component)this.listingMergePanel, (String)"User Defined Property Merge Error", (Object)msg);
            } else if (this.isUnsupportedMap(latestMap) || this.isUnsupportedMap(myMap)) {
                msg = "Latest and/or Checked Out program versions have unsupported property map '" + this.propNames[i] + "' which will be ignored.";
                Msg.showError((Object)this, (Component)this.listingMergePanel, (String)"User Defined Property Merge Error", (Object)msg);
                continue;
            }
            AddressIterator latestIter = latestMap != null ? latestMap.getPropertyIterator((AddressSetView)overlapSet) : null;
            AddressIterator myIter = myMap != null ? myMap.getPropertyIterator((AddressSetView)overlapSet) : null;
            AddressIterator originalIter = originalMap != null ? originalMap.getPropertyIterator((AddressSetView)overlapSet) : null;
            MultiAddressIterator addrIter = new MultiAddressIterator(new AddressIterator[]{latestIter, myIter, originalIter});
            while (addrIter.hasNext()) {
                Address addr = addrIter.next();
                Object latestObj = latestMap != null ? latestMap.get(addr) : null;
                Object myObj = myMap != null ? myMap.get(addr) : null;
                Object originalObj = originalMap != null ? originalMap.get(addr) : null;
                boolean sameLatestMy = Objects.equals(latestObj, myObj);
                if (sameLatestMy) continue;
                boolean sameOriginalLatest = Objects.equals(originalObj, latestObj);
                boolean sameOriginalMy = Objects.equals(originalObj, myObj);
                if (sameOriginalLatest) {
                    this.merge(this.propNames[i], addr, 4);
                    continue;
                }
                if (sameOriginalMy) continue;
                this.conflictSets[i].addRange(addr, addr);
                this.conflictSet.addRange(addr, addr);
            }
            this.incrementProgress(1);
        }
        this.updateProgress(100, "Done auto-merging User Defined Properties and determining conflicts.");
    }

    private boolean isUnsupportedMap(PropertyMap<?> map) {
        if (map == null) {
            return false;
        }
        Class valueClass = map.getValueClass();
        return valueClass == null || GenericSaveable.class.equals((Object)valueClass);
    }

    private boolean samePropertyTypes(PropertyMap<?> latestMap, PropertyMap<?> myMap) {
        if (latestMap == null || myMap == null) {
            return true;
        }
        Class latestValueClass = latestMap.getValueClass();
        Class myValueClass = myMap.getValueClass();
        return Objects.equals(myValueClass, latestValueClass);
    }

    private String[] getPropertyNames() {
        Listing latestListing = this.latestPgm.getListing();
        Listing myListing = this.myPgm.getListing();
        Iterator latestProps = latestListing.getUserDefinedProperties();
        Iterator myProps = myListing.getUserDefinedProperties();
        ArrayList<String> list = new ArrayList<String>();
        while (latestProps.hasNext()) {
            list.add((String)latestProps.next());
        }
        while (myProps.hasNext()) {
            String propName = (String)myProps.next();
            if (list.contains(propName) || propName.equals("Bookmarks")) continue;
            list.add(propName);
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public boolean hasConflict(Address addr) {
        return this.conflictSet.contains(addr);
    }

    @Override
    public int getConflictCount(Address addr) {
        int count = 0;
        for (int i = 0; i < this.conflictSets.length; ++i) {
            AddressSet addrSet = this.conflictSets[i];
            if (!addrSet.contains(addr)) continue;
            ++count;
        }
        return count;
    }

    private void setupConflictsPanel(ListingMergePanel listingPanel, String propertyName, Address addr, ChangeListener changeListener) {
        Object originalObj;
        PropertyMap latestMap = this.latestPMM.getPropertyMap(propertyName);
        PropertyMap myMap = this.myPMM.getPropertyMap(propertyName);
        PropertyMap originalMap = this.originalPMM.getPropertyMap(propertyName);
        Object latestObj = latestMap != null ? latestMap.get(addr) : null;
        Object myObj = myMap != null ? myMap.get(addr) : null;
        Object object = originalObj = originalMap != null ? originalMap.get(addr) : null;
        if (this.conflictPanel != null) {
            this.conflictPanel.clear();
        } else {
            this.conflictPanel = new VerticalChoicesPanel();
            this.currentConflictPanel = this.conflictPanel;
        }
        this.conflictPanel.setConflictType(propertyName + " property");
        this.conflictPanel.setUseForAll(false);
        this.conflictPanel.setTitle(this.getConflictType());
        String latest = this.createButtonText("Latest", propertyName, latestObj);
        String my = this.createButtonText("Checked Out", propertyName, myObj);
        String original = this.createButtonText("Original", propertyName, originalObj);
        String latestStr = latestObj != null ? ConflictUtility.getTruncatedHTMLString(latestObj.toString(), 160) : ConflictUtility.NO_VALUE;
        String myStr = myObj != null ? ConflictUtility.getTruncatedHTMLString(myObj.toString(), 160) : ConflictUtility.NO_VALUE;
        String originalStr = originalObj != null ? ConflictUtility.getTruncatedHTMLString(originalObj.toString(), 160) : ConflictUtility.NO_VALUE;
        this.conflictPanel.setRowHeader(new String[]{"Option", "'" + propertyName + "' Property"});
        this.conflictPanel.addRadioButtonRow(new String[]{latest, latestStr}, "LatestVersionRB", 2, changeListener);
        this.conflictPanel.addRadioButtonRow(new String[]{my, myStr}, "CheckedOutVersionRB", 4, changeListener);
        this.conflictPanel.addRadioButtonRow(new String[]{original, originalStr}, "OriginalVersionRB", 1, changeListener);
        listingPanel.setBottomComponent(this.conflictPanel);
    }

    @Override
    public void mergeConflicts(ListingMergePanel listingPanel, Address addr, int mergeConflictOption, TaskMonitor monitor) throws CancelledException, MemoryAccessException {
        if (!this.hasConflict(addr)) {
            return;
        }
        monitor.setMessage("Resolving User Defined Property conflicts.");
        for (int i = 0; i < this.propNames.length; ++i) {
            this.propertyIndex = i;
            this.propertyName = this.propNames[i];
            if (!this.conflictSets[i].contains(addr)) continue;
            if (this.sameOption[this.propertyIndex] == 0 && mergeConflictOption != 0) {
                this.sameOption[this.propertyIndex] = mergeConflictOption;
            }
            if (this.sameOption[this.propertyIndex] == 0 && this.mergeManager != null) {
                this.showMergePanel(listingPanel, this.propertyName, addr);
                monitor.checkCancelled();
                continue;
            }
            this.merge(this.propertyName, addr, this.sameOption[this.propertyIndex]);
        }
    }

    private void merge(String propName, Address addr, int mergeConflictOption) {
        if ((mergeConflictOption & 1) != 0) {
            this.listingMergeMgr.mergeOriginal.mergeUserProperty(propName, addr);
        } else if ((mergeConflictOption & 2) != 0) {
            this.listingMergeMgr.mergeLatest.mergeUserProperty(propName, addr);
        } else if ((mergeConflictOption & 4) != 0) {
            this.listingMergeMgr.mergeMy.mergeUserProperty(propName, addr);
        }
    }

    private void showMergePanel(final ListingMergePanel listingPanel, String userDefinedPropertyName, final Address addr) {
        this.propertyName = userDefinedPropertyName;
        this.currentAddress = addr;
        try {
            final ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    UserDefinedPropertyMerger.this.conflictOption = UserDefinedPropertyMerger.this.conflictPanel.getSelectedOptions();
                    if (UserDefinedPropertyMerger.this.conflictOption == 0) {
                        if (UserDefinedPropertyMerger.this.mergeManager != null) {
                            UserDefinedPropertyMerger.this.mergeManager.setApplyEnabled(false);
                        }
                        return;
                    }
                    if (UserDefinedPropertyMerger.this.mergeManager != null) {
                        UserDefinedPropertyMerger.this.mergeManager.clearStatusText();
                    }
                    UserDefinedPropertyMerger.this.merge(UserDefinedPropertyMerger.this.propertyName, UserDefinedPropertyMerger.this.currentAddress, UserDefinedPropertyMerger.this.conflictOption);
                    if (UserDefinedPropertyMerger.this.mergeManager != null) {
                        UserDefinedPropertyMerger.this.mergeManager.setApplyEnabled(true);
                    }
                }
            };
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    UserDefinedPropertyMerger.this.setupConflictsPanel(listingPanel, UserDefinedPropertyMerger.this.propertyName, UserDefinedPropertyMerger.this.currentAddress, changeListener);
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    listingPanel.clearAllBackgrounds();
                    listingPanel.paintAllBackgrounds((AddressSetView)new AddressSet(addr, addr));
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (this.mergeManager != null) {
            this.mergeManager.setApplyEnabled(false);
            this.mergeManager.showListingMergePanel(this.currentAddress);
        }
    }

    private String createButtonText(String version, String userDefinedPropertyName, Object propertyObj) {
        if (propertyObj != null) {
            return "Keep '" + version + "' version";
        }
        return "Delete as in '" + version + "' version";
    }

    @Override
    public AddressSetView getConflicts() {
        return this.conflictSet;
    }

    @Override
    public boolean apply() {
        this.numConflictsResolved = 0;
        if (this.conflictPanel != null) {
            if (this.propertyIndex < this.sameOption.length && this.sameOption[this.propertyIndex] == 0 && this.conflictPanel.getUseForAll()) {
                this.sameOption[this.propertyIndex] = this.conflictOption;
            }
            this.numConflictsResolved = this.conflictPanel.getNumConflictsResolved();
            if (this.conflictPanel.allChoicesAreResolved()) {
                this.conflictPanel.removeAllListeners();
                return true;
            }
            return false;
        }
        return true;
    }
}

