/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.extensions;

import ghidra.util.extensions.ExtensionDetails;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import utilities.util.FileUtilities;

public class Extensions {
    private Logger log;
    private Map<String, List<ExtensionDetails>> extensionsByName = new HashMap<String, List<ExtensionDetails>>();

    Extensions(Logger log) {
        this.log = log;
    }

    public List<ExtensionDetails> getMatchingExtensions(ExtensionDetails e) {
        return this.extensionsByName.computeIfAbsent(e.getName(), name -> new ArrayList());
    }

    void add(ExtensionDetails e) {
        this.extensionsByName.computeIfAbsent(e.getName(), n -> new ArrayList()).add(e);
    }

    Set<ExtensionDetails> getActiveExtensions() {
        return this.extensionsByName.values().stream().filter(list -> !list.isEmpty()).map(list -> (ExtensionDetails)list.get(0)).filter(ext -> !ext.isPendingUninstall()).collect(Collectors.toSet());
    }

    void cleanupExtensionsMarkedForRemoval() {
        HashSet<String> names = new HashSet<String>(this.extensionsByName.keySet());
        for (String name : names) {
            List<ExtensionDetails> extensions = this.extensionsByName.get(name);
            Iterator<ExtensionDetails> it = extensions.iterator();
            while (it.hasNext()) {
                ExtensionDetails extension = it.next();
                if (!extension.isPendingUninstall()) continue;
                if (!this.removeExtension(extension)) {
                    this.log.error("Error removing extension: " + extension.getInstallPath());
                }
                it.remove();
            }
            if (!extensions.isEmpty()) continue;
            this.extensionsByName.remove(name);
        }
    }

    private boolean removeExtension(ExtensionDetails extension) {
        if (extension == null) {
            this.log.error("Extension to uninstall cannot be null");
            return false;
        }
        File installDir = extension.getInstallDir();
        if (installDir == null) {
            this.log.error("Extension installation path is not set; unable to delete files");
            return false;
        }
        if (FileUtilities.deleteDir((File)installDir)) {
            extension.setInstallDir(null);
            return true;
        }
        return false;
    }

    Set<ExtensionDetails> get() {
        return this.extensionsByName.values().stream().filter(list -> !list.isEmpty()).map(list -> (ExtensionDetails)list.get(0)).collect(Collectors.toSet());
    }

    String getAsString() {
        StringBuilder buffy = new StringBuilder();
        Set<Map.Entry<String, List<ExtensionDetails>>> entries = this.extensionsByName.entrySet();
        for (Map.Entry<String, List<ExtensionDetails>> entry : entries) {
            String name = entry.getKey();
            buffy.append("Name: ").append(name);
            List<ExtensionDetails> extensions = entry.getValue();
            if (extensions.size() == 1) {
                buffy.append(" - ").append(extensions.get(0).getInstallDir()).append('\n');
                continue;
            }
            for (ExtensionDetails e : extensions) {
                buffy.append("\t").append(e.getInstallDir()).append('\n');
            }
        }
        if (buffy.isEmpty()) {
            return "<no extensions installed>";
        }
        buffy.deleteCharAt(buffy.length() - 1);
        return buffy.toString();
    }

    void reportDuplicateExtensions() {
        Set<Map.Entry<String, List<ExtensionDetails>>> entries = this.extensionsByName.entrySet();
        for (Map.Entry<String, List<ExtensionDetails>> entry : entries) {
            List<ExtensionDetails> list = entry.getValue();
            if (list.size() == 1) continue;
            this.reportDuplicateExtensionsWhenLoading(entry.getKey(), list);
        }
    }

    private void reportDuplicateExtensionsWhenLoading(String name, List<ExtensionDetails> extensions) {
        ExtensionDetails loadedExtension = extensions.get(0);
        File loadedInstallDir = loadedExtension.getInstallDir();
        for (int i = 1; i < extensions.size(); ++i) {
            ExtensionDetails duplicate = extensions.get(i);
            this.log.info("Duplicate extension found '" + name + "'.  Keeping extension from " + String.valueOf(loadedInstallDir) + ".  Skipping extension found at " + String.valueOf(duplicate.getInstallDir()));
        }
    }
}

