/*
 * Decompiled with CFR 0.152.
 */
package generic;

import java.util.Iterator;
import java.util.function.Predicate;

public class FilteredIterator<T>
implements Iterator<T>,
Iterable<T> {
    private Iterator<T> it;
    private Predicate<T> filter;
    private T nextThing;

    public FilteredIterator(Iterator<T> it, Predicate<T> filter) {
        this.it = it;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        if (this.nextThing != null) {
            return true;
        }
        return this.findNext();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T t = this.nextThing;
            this.nextThing = null;
            return t;
        }
        return null;
    }

    private boolean findNext() {
        while (this.it.hasNext()) {
            T t = this.it.next();
            if (!this.filter.test(t)) continue;
            this.nextThing = t;
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

