/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.datatype.modifier;

import java.util.ArrayList;
import java.util.List;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDType;
import mdemangler.datatype.modifier.MDBasedAttribute;
import mdemangler.datatype.modifier.MDCVMod;
import mdemangler.naming.MDQualification;

public class MDModifiedTypeParser {
    private boolean isPointer64;
    private boolean isUnaligned;
    private boolean isRestricted;
    private boolean isConst;
    private boolean isVolatile;
    private boolean isFunction;
    private boolean isBased;
    private boolean isMember;
    private boolean isData;
    private boolean foundManagedProperty;
    private boolean isGC;
    private boolean isPinPointer;
    private boolean isCLIProperty;
    private boolean isCLIArray;
    private int arrayRank;
    private boolean noProperties;
    private boolean noCV;
    String special;
    private MDQualification qual;
    private MDCVMod cvMod;
    private MDBasedAttribute basedType;
    private List<CvPrefix> prefixList = new ArrayList<CvPrefix>();
    private CvModifierType modType = CvModifierType.plain;

    public void clearProperties() {
        this.noProperties = true;
    }

    public boolean hasProperties() {
        return !this.noProperties;
    }

    public void clearCV() {
        this.noCV = true;
    }

    public boolean hasCV() {
        return !this.noCV;
    }

    public void setArrayType() {
        this.modType = CvModifierType.array;
    }

    public void setPointerType() {
        this.modType = CvModifierType.pointer;
    }

    public void setReferenceType() {
        this.modType = CvModifierType.reference;
    }

    public void setRightReferenceParameter() {
        this.modType = CvModifierType.rightreference;
    }

    public void setOthererType() {
        this.modType = CvModifierType.other;
    }

    public boolean isPointerType() {
        return this.modType == CvModifierType.pointer;
    }

    public boolean isReferenceType() {
        return this.modType == CvModifierType.reference;
    }

    public boolean isFunctionPointerType() {
        return this.isFunction && this.modType == CvModifierType.pointer;
    }

    public boolean isFunctionReferenceType() {
        return this.isFunction && this.modType == CvModifierType.reference;
    }

    public boolean isArrayType() {
        return this.modType == CvModifierType.array;
    }

    public boolean isOtherType() {
        return this.modType == CvModifierType.other;
    }

    public MDCVMod getMDCVModifier() {
        return this.cvMod;
    }

    public boolean isPointer64() {
        return this.isPointer64;
    }

    public void setGC() {
        this.isGC = true;
    }

    public boolean isGC() {
        return this.isGC;
    }

    public void setPinPointer() {
        this.isPinPointer = true;
    }

    public boolean isPinPointer() {
        return this.isPinPointer;
    }

    public void setCLIProperty() {
        this.isCLIProperty = true;
    }

    public boolean isCLIProperty() {
        return this.isCLIProperty;
    }

    public void setCLIArray() {
        this.isCLIArray = true;
    }

    public boolean isCLIArray() {
        return this.isCLIArray;
    }

    public boolean isUnaligned() {
        return this.isUnaligned;
    }

    public boolean isRestricted() {
        return this.isRestricted;
    }

    public void setConst() {
        this.isConst = true;
    }

    public void clearConst() {
        this.isConst = false;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public void setVolatile() {
        this.isVolatile = true;
    }

    public void clearVolatile() {
        this.isVolatile = false;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public boolean isMember() {
        return this.isMember;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public boolean isData() {
        return this.isData;
    }

    public boolean isBasedPtrBased() {
        return this.isBased && this.basedType.isBasedPtrBased();
    }

    public void checkInvalidSymbol() throws MDException {
        if (this.isFunction && (this.foundManagedProperty || this.prefixList.size() != 0)) {
            throw new MDException("EFI and Managed Properies not permitted for function pointer/reference");
        }
        if (this.isFunction && this.modType == CvModifierType.plain) {
            throw new MDException("Function refType only permitted on pointer or reference");
        }
    }

    public MDType parse(MDMang dmang) throws MDException {
        if (this.hasProperties()) {
            this.parseEFI(dmang);
            while (this.parseManagedProperty(dmang) && this.parseEFI(dmang)) {
            }
        }
        if (this.hasCV()) {
            this.parseCV(dmang);
        }
        this.checkInvalidSymbol();
        return null;
    }

    private boolean parseEFI(MDMang dmang) {
        boolean prefixDone = false;
        boolean foundOne = false;
        block5: while (!prefixDone) {
            switch (dmang.peek()) {
                case 'E': {
                    dmang.parseInfoPush(0, "__ptr64");
                    dmang.increment();
                    this.isPointer64 = true;
                    foundOne = true;
                    this.prefixList.add(CvPrefix.ptr64);
                    dmang.parseInfoPop();
                    continue block5;
                }
                case 'F': {
                    dmang.parseInfoPush(0, "__unaligned");
                    dmang.increment();
                    this.isUnaligned = true;
                    foundOne = true;
                    this.prefixList.add(CvPrefix.unaligned);
                    dmang.parseInfoPop();
                    continue block5;
                }
                case 'I': {
                    dmang.parseInfoPush(0, "__restricted");
                    dmang.increment();
                    this.isRestricted = true;
                    foundOne = true;
                    this.prefixList.add(CvPrefix.restrict);
                    dmang.parseInfoPop();
                    continue block5;
                }
            }
            prefixDone = true;
        }
        return foundOne;
    }

    public boolean parseManagedProperty(MDMang dmang) throws MDException {
        if (dmang.peek() != '$') {
            return false;
        }
        dmang.increment();
        char code = dmang.peek();
        switch (code) {
            case 'A': {
                dmang.increment();
                this.setGC();
                break;
            }
            case 'B': {
                dmang.increment();
                if (this.modType == CvModifierType.plain || this.modType == CvModifierType.array || this.modType == CvModifierType.other) break;
                this.setPinPointer();
                break;
            }
            case 'C': {
                dmang.increment();
                this.setCLIProperty();
                if (this.modType != CvModifierType.plain) break;
                this.setPointerType();
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.setCLIArray();
                dmang.increment();
                if (code >= '0' && code <= '9') {
                    this.arrayRank = code - 48;
                } else if (code >= 'A' && code <= 'F') {
                    this.arrayRank = code - 65 + 10;
                } else {
                    throw new MDException("invalid cli:array rank");
                }
                code = dmang.getAndIncrement();
                this.arrayRank = this.arrayRank * 16 + code - 48;
                break;
            }
            default: {
                throw new MDException("unknown managed property: " + code);
            }
        }
        this.foundManagedProperty = true;
        return true;
    }

    private MDType parseCV(MDMang dmang) throws MDException {
        char code = dmang.getAndIncrement();
        block0 : switch (code) {
            case 'A': {
                this.isData = true;
                break;
            }
            case 'B': 
            case 'J': {
                this.isData = true;
                this.isConst = true;
                break;
            }
            case 'C': 
            case 'G': 
            case 'K': {
                this.isData = true;
                this.isVolatile = true;
                break;
            }
            case 'D': 
            case 'H': 
            case 'L': {
                this.isData = true;
                this.isConst = true;
                this.isVolatile = true;
                break;
            }
            case 'M': {
                this.isData = true;
                this.isBased = true;
                break;
            }
            case 'N': {
                this.isData = true;
                this.isConst = true;
                this.isBased = true;
                break;
            }
            case 'O': {
                this.isData = true;
                this.isVolatile = true;
                this.isBased = true;
                break;
            }
            case 'P': {
                this.isData = true;
                this.isConst = true;
                this.isVolatile = true;
                this.isBased = true;
                break;
            }
            case 'Q': 
            case 'U': 
            case 'Y': {
                this.isData = true;
                this.isMember = true;
                break;
            }
            case 'R': 
            case 'V': 
            case 'Z': {
                this.isData = true;
                this.isConst = true;
                this.isMember = true;
                break;
            }
            case '0': 
            case 'S': 
            case 'W': {
                this.isData = true;
                this.isVolatile = true;
                this.isMember = true;
                break;
            }
            case '1': 
            case 'T': 
            case 'X': {
                this.isData = true;
                this.isConst = true;
                this.isVolatile = true;
                this.isMember = true;
                break;
            }
            case '2': {
                this.isData = true;
                this.isBased = true;
                this.isMember = true;
                break;
            }
            case '3': {
                this.isData = true;
                this.isConst = true;
                this.isBased = true;
                this.isMember = true;
                break;
            }
            case '4': {
                this.isData = true;
                this.isVolatile = true;
                this.isBased = true;
                this.isMember = true;
                break;
            }
            case '5': {
                this.isData = true;
                this.isConst = true;
                this.isVolatile = true;
                this.isBased = true;
                this.isMember = true;
                break;
            }
            case '6': 
            case '7': {
                this.isFunction = true;
                break;
            }
            case '8': 
            case '9': {
                this.isFunction = true;
                this.isMember = true;
                break;
            }
            case '_': {
                this.isFunction = true;
                char code1 = dmang.getAndIncrement();
                switch (code1) {
                    case 'A': 
                    case 'B': {
                        this.isBased = true;
                        break block0;
                    }
                    case 'C': 
                    case 'D': {
                        this.isBased = true;
                        this.isMember = true;
                        break block0;
                    }
                }
                throw new MDException("CV code not expected: _" + code1);
            }
            case '\uffff': {
                break;
            }
            default: {
                throw new MDException("CV code not expected: " + code);
            }
        }
        if (this.isMember) {
            this.qual = new MDQualification(dmang);
            this.qual.parse();
            if (this.isFunction) {
                this.cvMod = new MDCVMod(dmang);
                this.cvMod.parse();
            }
        }
        if (this.isBased) {
            this.basedType = new MDBasedAttribute(dmang);
            this.basedType.parse();
        }
        return null;
    }

    private static enum CvModifierType {
        plain,
        pointer,
        reference,
        rightreference,
        caret,
        percent,
        functionpointer,
        functionreference,
        array,
        other;

    }

    private static enum CvPrefix {
        ptr64,
        unaligned,
        restrict;

    }
}

