/*
 * Decompiled with CFR 0.152.
 */
package ghidra.launch;

import ghidra.launch.AppConfig;
import ghidra.launch.JavaVersion;
import ghidra.launch.LinuxJavaFinder;
import ghidra.launch.MacJavaFinder;
import ghidra.launch.WindowsJavaFinder;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

public abstract class JavaFinder {
    public static Platform getCurrentPlatform() {
        String os = System.getProperty("os.name");
        if (os != null) {
            if ((os = os.toLowerCase()).contains("win")) {
                return Platform.WINDOWS;
            }
            if (os.contains("mac")) {
                return Platform.MACOS;
            }
        }
        return Platform.LINUX;
    }

    public static JavaFinder create() {
        switch (JavaFinder.getCurrentPlatform().ordinal()) {
            case 0: {
                return new WindowsJavaFinder();
            }
            case 1: {
                return new MacJavaFinder();
            }
        }
        return new LinuxJavaFinder();
    }

    public List<File> findSupportedJavaHomeFromInstallations(AppConfig appConfig, JavaFilter javaFilter) {
        TreeSet<File> potentialJavaHomeSet = new TreeSet<File>();
        for (File file : this.getJavaRootInstallDirs()) {
            if (!file.isDirectory()) continue;
            for (File dir : file.listFiles()) {
                if (!dir.isDirectory()) continue;
                dir = new File(dir, this.getJavaHomeSubDirPath());
                if (javaFilter.equals((Object)JavaFilter.ANY) || javaFilter.equals((Object)JavaFilter.JDK_ONLY)) {
                    potentialJavaHomeSet.add(this.getJdkHomeFromJavaHome(dir));
                }
                if (!javaFilter.equals((Object)JavaFilter.ANY) && !javaFilter.equals((Object)JavaFilter.JRE_ONLY)) continue;
                potentialJavaHomeSet.add(this.getJreHomeFromJavaHome(dir));
            }
        }
        final HashMap<File, JavaVersion> javaHomeToVersionMap = new HashMap<File, JavaVersion>();
        for (File potentialJavaHomeDir : potentialJavaHomeSet) {
            try {
                JavaVersion javaVersion = appConfig.getJavaVersion(potentialJavaHomeDir, javaFilter);
                if (!appConfig.isJavaVersionSupported(javaVersion)) continue;
                javaHomeToVersionMap.put(potentialJavaHomeDir, javaVersion);
            }
            catch (IOException | ParseException exception) {}
        }
        ArrayList<File> arrayList = new ArrayList<File>(javaHomeToVersionMap.keySet());
        Collections.sort(arrayList, new Comparator<File>(){

            @Override
            public int compare(File dir1, File dir2) {
                return ((JavaVersion)javaHomeToVersionMap.get(dir2)).compareTo((JavaVersion)javaHomeToVersionMap.get(dir1));
            }
        });
        return arrayList;
    }

    public File findSupportedJavaHomeFromCurrentJavaHome(AppConfig appConfig, JavaFilter javaFilter) {
        HashSet<File> potentialJavaHomeSet = new HashSet<File>();
        String javaHomeProperty = System.getProperty("java.home");
        if (javaHomeProperty != null && !javaHomeProperty.isEmpty()) {
            File dir = new File(javaHomeProperty);
            if (javaFilter.equals((Object)JavaFilter.ANY) || javaFilter.equals((Object)JavaFilter.JDK_ONLY)) {
                potentialJavaHomeSet.add(this.getJdkHomeFromJavaHome(dir));
            }
            if (javaFilter.equals((Object)JavaFilter.ANY) || javaFilter.equals((Object)JavaFilter.JRE_ONLY)) {
                potentialJavaHomeSet.add(this.getJreHomeFromJavaHome(dir));
            }
            for (File potentialJavaHomeDir : potentialJavaHomeSet) {
                try {
                    if (!appConfig.isJavaVersionSupported(appConfig.getJavaVersion(potentialJavaHomeDir, javaFilter))) continue;
                    return potentialJavaHomeDir;
                }
                catch (IOException | ParseException exception) {
                }
            }
        }
        return null;
    }

    protected abstract List<File> getJavaRootInstallDirs();

    protected abstract String getJavaHomeSubDirPath();

    protected abstract File getJreHomeFromJavaHome(File var1);

    protected abstract File getJdkHomeFromJavaHome(File var1);

    public static enum Platform {
        WINDOWS,
        MACOS,
        LINUX;

    }

    public static enum JavaFilter {
        JRE_ONLY,
        JDK_ONLY,
        ANY;

    }
}

