/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AbstractSignedIntegerDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.UnsignedLongLongDataType;

public class LongLongDataType
extends AbstractSignedIntegerDataType {
    public static final LongLongDataType dataType = new LongLongDataType();

    public LongLongDataType() {
        this(null);
    }

    public LongLongDataType(DataTypeManager dtm) {
        super("longlong", dtm);
    }

    @Override
    public int getLength() {
        return this.getDataOrganization().getLongLongSize();
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Signed Long Long Integer (compiler-specific size)";
    }

    @Override
    public String getCDeclaration() {
        return "long long";
    }

    @Override
    public UnsignedLongLongDataType getOppositeSignednessDataType() {
        return UnsignedLongLongDataType.dataType.clone(this.getDataTypeManager());
    }

    @Override
    public LongLongDataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new LongLongDataType(dtm);
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        return this.getCTypeDeclaration(this.getName(), "long long", false);
    }
}

