/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import ghidra.program.database.code.CodeManager;
import ghidra.program.database.map.AddressKeyIterator;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import java.io.IOException;
import java.util.Iterator;

public class CodeUnitKeyIterator
implements CodeUnitIterator {
    private CodeManager codeMgr;
    private AddressKeyIterator it;
    private boolean forward;
    private CodeUnit nextCu;

    public CodeUnitKeyIterator(CodeManager codeMgr, AddressKeyIterator it, boolean forward) {
        this.codeMgr = codeMgr;
        this.it = it;
        this.forward = forward;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.nextCu == null) {
            this.findNext();
        }
        return this.nextCu != null;
    }

    @Override
    public CodeUnit next() {
        if (this.hasNext()) {
            CodeUnit ret = this.nextCu;
            this.nextCu = null;
            return ret;
        }
        return null;
    }

    private void findNext() {
        try {
            while (this.nextCu == null) {
                long addr;
                if (this.forward) {
                    if (!this.it.hasNext()) break;
                    addr = this.it.next();
                } else {
                    if (!this.it.hasPrevious()) break;
                    addr = this.it.previous();
                }
                this.nextCu = this.codeMgr.getCodeUnitAt(addr);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Iterator<CodeUnit> iterator() {
        return this;
    }
}

