/*
 * Decompiled with CFR 0.152.
 */
package resources.icons;

import generic.theme.GIcon;
import generic.util.image.ImageUtils;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;
import resources.icons.LazyImageIcon;

public class DerivedImageIcon
extends LazyImageIcon {
    private Icon sourceIcon;
    private Image sourceImage;
    private Icon cachedDelegate;

    public DerivedImageIcon(Icon icon) {
        super(ResourceManager.getIconName(icon));
        this.sourceIcon = Objects.requireNonNull(icon);
    }

    public DerivedImageIcon(String name, Image image) {
        super(name);
        this.sourceImage = Objects.requireNonNull(image);
    }

    public Icon getSourceIcon() {
        return this.sourceIcon;
    }

    @Override
    protected boolean sourceIconChanged() {
        GIcon gIcon;
        Icon icon = this.sourceIcon;
        if (icon instanceof GIcon && this.cachedDelegate != (gIcon = (GIcon)icon).getDelegate()) {
            this.cachedDelegate = gIcon.getDelegate();
            return true;
        }
        return false;
    }

    @Override
    protected ImageIcon createImageIcon() {
        Image image = this.createImage();
        String imageName = this.getFilename();
        if (!ImageUtils.waitForImage(imageName, image)) {
            return null;
        }
        return new ImageIcon(image, imageName);
    }

    protected Image createImage() {
        if (this.sourceImage != null) {
            return this.sourceImage;
        }
        if (this.sourceIcon instanceof ImageIcon) {
            return ((ImageIcon)this.sourceIcon).getImage();
        }
        BufferedImage bufferedImage = new BufferedImage(this.sourceIcon.getIconWidth(), this.sourceIcon.getIconHeight(), 2);
        Graphics graphics = bufferedImage.getGraphics();
        this.sourceIcon.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return bufferedImage;
    }
}

