/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.ActionTrigger;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.OptionsEditor;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.KeyStroke;
import utilities.util.reflection.ReflectionUtilities;

public interface Options {
    public static final char DELIMITER = '.';
    public static final String DELIMITER_STRING = new String(new char[]{'.'});
    public static final String ILLEGAL_DELIMITER = DELIMITER_STRING + DELIMITER_STRING;

    public String getName();

    public String getID(String var1);

    public OptionType getType(String var1);

    public PropertyEditor getPropertyEditor(String var1);

    public PropertyEditor getRegisteredPropertyEditor(String var1);

    public List<Options> getChildOptions();

    public List<String> getLeafOptionNames();

    public void setOptionsHelpLocation(HelpLocation var1);

    public HelpLocation getOptionsHelpLocation();

    public HelpLocation getHelpLocation(String var1);

    public void registerOption(String var1, Object var2, HelpLocation var3, String var4);

    public void registerOption(String var1, OptionType var2, Object var3, HelpLocation var4, String var5);

    public void registerOption(String var1, OptionType var2, Object var3, HelpLocation var4, String var5, Supplier<PropertyEditor> var6);

    @Deprecated(since="11.0.2", forRemoval=true)
    default public void registerOption(String optionName, OptionType type, Object defaultValue, HelpLocation help, String description, PropertyEditor editor) {
        String caller = ReflectionUtilities.getClassNameOlderThan((Class[])new Class[]{Options.class});
        String message = "Using deprecated call to registerOption(PropertyEditor) from % for option %s\n".formatted(caller, optionName);
        Msg.debug((Object)this, (Object)message);
        this.registerOption(optionName, type, defaultValue, help, description, () -> editor);
    }

    public void registerThemeColorBinding(String var1, String var2, HelpLocation var3, String var4);

    public void registerThemeFontBinding(String var1, String var2, HelpLocation var3, String var4);

    public void registerOptionsEditor(Supplier<OptionsEditor> var1);

    @Deprecated(since="11.0.2", forRemoval=true)
    default public void registerOptionsEditor(OptionsEditor editor) {
        String caller = ReflectionUtilities.getClassNameOlderThan((Class[])new Class[]{Options.class});
        String message = "Using deprecated call to registerOption(OptionsEditor) from % for options %s\n".formatted(caller, this.getName());
        Msg.debug((Object)this, (Object)message);
        this.registerOptionsEditor(() -> editor);
    }

    public OptionsEditor getOptionsEditor();

    public void putObject(String var1, Object var2);

    public Object getObject(String var1, Object var2);

    public boolean getBoolean(String var1, boolean var2);

    public byte[] getByteArray(String var1, byte[] var2);

    public int getInt(String var1, int var2);

    public double getDouble(String var1, double var2);

    public float getFloat(String var1, float var2);

    public long getLong(String var1, long var2);

    public CustomOption getCustomOption(String var1, CustomOption var2);

    public Color getColor(String var1, Color var2);

    public File getFile(String var1, File var2);

    public Date getDate(String var1, Date var2);

    public Font getFont(String var1, Font var2);

    @Deprecated(since="11.1", forRemoval=true)
    public KeyStroke getKeyStroke(String var1, KeyStroke var2);

    public ActionTrigger getActionTrigger(String var1, ActionTrigger var2);

    public String getString(String var1, String var2);

    public <T extends Enum<T>> T getEnum(String var1, T var2);

    public void setLong(String var1, long var2);

    public void setBoolean(String var1, boolean var2);

    public void setInt(String var1, int var2);

    public void setDouble(String var1, double var2);

    public void setFloat(String var1, float var2);

    public void setCustomOption(String var1, CustomOption var2);

    public void setByteArray(String var1, byte[] var2);

    public void setFile(String var1, File var2);

    public void setDate(String var1, Date var2);

    public void setColor(String var1, Color var2);

    public void setFont(String var1, Font var2);

    @Deprecated(since="11.1", forRemoval=true)
    public void setKeyStroke(String var1, KeyStroke var2);

    public void setActionTrigger(String var1, ActionTrigger var2);

    public void setString(String var1, String var2);

    public <T extends Enum<T>> void setEnum(String var1, T var2);

    public void removeOption(String var1);

    public List<String> getOptionNames();

    public boolean contains(String var1);

    public String getDescription(String var1);

    public boolean isRegistered(String var1);

    public boolean isDefaultValue(String var1);

    public void restoreDefaultValues();

    public void restoreDefaultValue(String var1);

    public Options getOptions(String var1);

    public void createAlias(String var1, Options var2, String var3);

    public boolean isAlias(String var1);

    public Object getDefaultValue(String var1);

    public String getValueAsString(String var1);

    public String getDefaultValueAsString(String var1);

    public static boolean hasSameOptionsAndValues(Options options1, Options options2) {
        List<String> leafOptionNames1 = options1.getOptionNames();
        List<String> leafOptionNames2 = options2.getOptionNames();
        Collections.sort(leafOptionNames1);
        Collections.sort(leafOptionNames2);
        if (!leafOptionNames1.equals(leafOptionNames2)) {
            return false;
        }
        for (String optionName : leafOptionNames1) {
            Object value2;
            Object value1 = options1.getObject(optionName, null);
            if (Objects.equals(value1, value2 = options2.getObject(optionName, null))) continue;
            return false;
        }
        return true;
    }
}

