/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.function.Function;
import java.util.function.Supplier;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.util.synthetics.SingletonTransformer;
import org.jungrapht.visualization.layout.util.synthetics.TransformingGraphView;

public class TransformedGraphSupplier<V, E>
implements Supplier<Graph<LV<V>, LE<V, E>>> {
    protected Graph<V, E> graph;
    SingletonTransformer<V, LV<V>> vertexTransformer;

    public TransformedGraphSupplier(Graph<V, E> graph) {
        this.graph = graph;
    }

    public SingletonTransformer<V, LV<V>> getVertexTransformer() {
        return this.vertexTransformer;
    }

    @Override
    public Graph<LV<V>, LE<V, E>> get() {
        Function<Object, LV> vertexTransformFunction = LV::of;
        this.vertexTransformer = new SingletonTransformer<Object, LV>(vertexTransformFunction);
        Function<Object, LE> edgeTransformFunction = e -> LE.of(e, this.vertexTransformer.apply(this.graph.getEdgeSource(e)), this.vertexTransformer.apply(this.graph.getEdgeTarget(e)));
        SingletonTransformer<Object, LE> edgeTransformer = new SingletonTransformer<Object, LE>(edgeTransformFunction);
        Object builder = ((TransformingGraphView.Builder)TransformingGraphView.builder(this.graph).vertexTransformFunction(this.vertexTransformer)).edgeTransformFunction(edgeTransformer);
        Object graphView = ((TransformingGraphView.Builder)builder).build();
        return ((TransformingGraphView)graphView).build();
    }
}

