/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.DockingUtils;
import docking.UndoRedoKeeper;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class GTableTextCellEditor
extends DefaultCellEditor {
    private static final Object TABLE_FOCUS_CELL_HIGHLIGHT_BORDER = "Table.focusCellHighlightBorder";
    private UndoRedoKeeper undoRedoKeeper;

    public GTableTextCellEditor(JTextField textField) {
        super(textField);
        this.setClickCountToStart(2);
        textField.setBorder(UIManager.getBorder(TABLE_FOCUS_CELL_HIGHLIGHT_BORDER));
        this.undoRedoKeeper = DockingUtils.installUndoRedo(textField);
    }

    @Override
    public boolean stopCellEditing() {
        if (super.stopCellEditing()) {
            this.undoRedoKeeper.clear();
            return true;
        }
        return false;
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
        this.undoRedoKeeper.clear();
    }
}

