/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.shapes;

public enum Location {
    LEFT,
    RIGHT,
    TOP,
    BOTTOM,
    CENTER;

    private Boolean isGreater;
    private Boolean isHorizontal;
    private Location match;
    private Location clockwiseNext;

    private void set(Boolean isGreater, Boolean isHorizontal, Location match, Location clockwiseNext) {
        this.isGreater = isGreater;
        this.isHorizontal = isHorizontal;
        this.match = match;
        this.clockwiseNext = clockwiseNext;
    }

    public boolean isGreater() {
        return this.isGreater != null && this.isGreater != false;
    }

    public boolean isLesser() {
        return this.isGreater != null && this.isGreater == false;
    }

    public boolean isCenter() {
        return this.isGreater == null;
    }

    public Location match() {
        return this.match;
    }

    public Location clockwise() {
        return this.clockwiseNext;
    }

    public Location counterClockwise() {
        return this.clockwiseNext.match();
    }

    public boolean validMinor(Location minor) {
        return this.isHorizontal() && minor.isVertical() || this.isVertical() && minor.isHorizontal();
    }

    public boolean isHorizontal() {
        return this.isHorizontal == null || this.isHorizontal != false;
    }

    public boolean isVertical() {
        return this.isHorizontal == null || this.isHorizontal == false;
    }

    static {
        LEFT.set(false, true, RIGHT, TOP);
        RIGHT.set(true, true, LEFT, BOTTOM);
        TOP.set(false, false, BOTTOM, RIGHT);
        BOTTOM.set(true, false, TOP, LEFT);
        CENTER.set(null, null, null, null);
    }
}

