/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.field;

import docking.widgets.fieldpanel.field.ClippingTextField;
import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextField;
import docking.widgets.fieldpanel.field.VerticalLayoutTextField;
import docking.widgets.fieldpanel.support.FieldHighlightFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FlowLayoutTextField
extends VerticalLayoutTextField {
    @Deprecated(since="10.1", forRemoval=true)
    public FlowLayoutTextField(FieldElement[] textElements, int startX, int width, int maxLines, FieldHighlightFactory hlFactory) {
        this(Arrays.asList(textElements), startX, width, maxLines, hlFactory);
    }

    public FlowLayoutTextField(List<FieldElement> elements, int startX, int width, int maxLines, FieldHighlightFactory hlFactory) {
        super(FlowLayoutTextField.createLineElements(elements, width), startX, width, maxLines, hlFactory, "");
    }

    private static List<FieldElement> createLineElements(List<FieldElement> elements, int width) {
        int numberPerLine;
        ArrayList<FieldElement> subFields = new ArrayList<FieldElement>();
        for (int currentIndex = 0; currentIndex < elements.size(); currentIndex += numberPerLine) {
            numberPerLine = FlowLayoutTextField.getNumberOfElementsPerLine(elements, currentIndex, width);
            subFields.add(FlowLayoutTextField.createLineFromElements(elements, currentIndex, numberPerLine));
        }
        return subFields;
    }

    @Override
    protected TextField createFieldForLine(FieldElement element) {
        CompositeFieldElement composite = (CompositeFieldElement)element;
        int numDataRows = composite.getNumElements();
        return new ClippingTextField(this.startX, this.width, element, numDataRows, this.hlFactory);
    }

    private static CompositeFieldElement createLineFromElements(List<FieldElement> elements, int start, int length) {
        return new CompositeFieldElement(elements.subList(start, start + length));
    }

    private static int getNumberOfElementsPerLine(List<FieldElement> elements, int start, int width) {
        int currentWidth = 0;
        for (int i = start; i < elements.size(); ++i) {
            FieldElement element = elements.get(i);
            if ((currentWidth += element.getStringWidth()) <= width) continue;
            int count = i - start;
            return Math.max(count, 1);
        }
        return elements.size() - start;
    }
}

