/*
 * Decompiled with CFR 0.152.
 */
package docking.framework;

import docking.DockingErrorDisplay;
import docking.framework.SplashScreen;
import docking.widgets.PopupKeyStorePasswordProvider;
import generic.theme.ApplicationThemeManager;
import ghidra.docking.util.LookAndFeelUtils;
import ghidra.framework.ApplicationConfiguration;
import ghidra.net.ApplicationKeyManagerFactory;
import ghidra.security.KeyStorePasswordProvider;
import ghidra.util.ErrorDisplay;

public class DockingApplicationConfiguration
extends ApplicationConfiguration {
    private boolean showSplashScreen = true;

    public boolean isHeadless() {
        return false;
    }

    public ErrorDisplay getErrorDisplay() {
        return new DockingErrorDisplay();
    }

    public void setShowSplashScreen(boolean showSplashScreen) {
        this.showSplashScreen = showSplashScreen;
    }

    public boolean isShowSplashScreen() {
        return this.showSplashScreen;
    }

    protected void initializeApplication() {
        super.initializeApplication();
        ApplicationThemeManager.initialize();
        LookAndFeelUtils.performPlatformSpecificFixups();
        if (this.showSplashScreen) {
            SplashScreen.showLater();
        }
        ApplicationKeyManagerFactory.setKeyStorePasswordProvider((KeyStorePasswordProvider)new PopupKeyStorePasswordProvider());
    }
}

