/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.DefaultFocusOwnerProvider;
import docking.DockingDialog;
import docking.DockingMouseBindingAction;
import docking.DockingWindowManager;
import docking.FocusOwnerProvider;
import docking.MouseEntryTextField;
import ghidra.util.Msg;
import gui.event.MouseBinding;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class MouseBindingMouseEventDispatcher {
    private static MouseBindingMouseEventDispatcher instance;
    private FocusOwnerProvider focusProvider = new DefaultFocusOwnerProvider();
    private PendingActionInfo inProgressAction;

    static synchronized void install() {
        if (instance == null) {
            instance = new MouseBindingMouseEventDispatcher();
        }
    }

    private MouseBindingMouseEventDispatcher() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        AWTEventListener listener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                MouseBindingMouseEventDispatcher.this.process((MouseEvent)event);
            }
        };
        toolkit.addAWTEventListener(listener, 16L);
    }

    private boolean isSettingMouseBinding(MouseEvent e) {
        Component destination = e.getComponent();
        if (destination == null) {
            Component focusOwner;
            destination = focusOwner = this.focusProvider.getFocusOwner();
        }
        return destination instanceof MouseEntryTextField;
    }

    private void process(MouseEvent e) {
        int id = e.getID();
        if (id == 504 || id == 505) {
            return;
        }
        if (this.isSettingMouseBinding(e)) {
            return;
        }
        if (this.actionInProgress(e)) {
            return;
        }
        MouseBinding mouseBinding = MouseBinding.getMouseBinding((MouseEvent)e);
        DockingMouseBindingAction action = this.getDockingKeyBindingActionForEvent(mouseBinding);
        Msg.trace((Object)this, (Object)new ParameterizedMessage("Mouse binding to action: {} to {}", (Object)mouseBinding, (Object)action));
        if (action == null) {
            return;
        }
        this.inProgressAction = new PendingActionInfo(action, mouseBinding);
        e.consume();
    }

    private boolean actionInProgress(MouseEvent e) {
        int bindingButton;
        int eventButton;
        if (this.inProgressAction == null) {
            Msg.trace((Object)this, (Object)"No mouse binding action in progress");
            return false;
        }
        MouseBinding mouseBinding = this.inProgressAction.mouseBinding();
        boolean isMatching = mouseBinding.isMatchingRelease(e);
        Msg.trace((Object)this, (Object)new ParameterizedMessage("Is release event for in-progress mouse binding action? {} for {}", (Object)isMatching, (Object)this.inProgressAction.action()));
        if (isMatching) {
            DockingMouseBindingAction action = this.inProgressAction.action();
            this.inProgressAction = null;
            String command = null;
            Object source = e.getSource();
            long when = e.getWhen();
            int modifiers = e.getModifiersEx();
            action.actionPerformed(new ActionEvent(source, 1001, command, when, modifiers));
        }
        if ((eventButton = e.getButton()) != (bindingButton = mouseBinding.getButton())) {
            this.inProgressAction = null;
            return false;
        }
        e.consume();
        return true;
    }

    private DockingMouseBindingAction getDockingKeyBindingActionForEvent(MouseBinding mouseBinding) {
        DockingWindowManager activeManager = this.getActiveDockingWindowManager();
        if (activeManager == null) {
            return null;
        }
        DockingMouseBindingAction bindingAction = (DockingMouseBindingAction)activeManager.getActionForMouseBinding(mouseBinding);
        return bindingAction;
    }

    private DockingWindowManager getActiveDockingWindowManager() {
        Window activeWindow = this.focusProvider.getActiveWindow();
        if (activeWindow == null) {
            return null;
        }
        DockingWindowManager activeManager = DockingWindowManager.getActiveInstance();
        if (activeManager == null) {
            return null;
        }
        DockingWindowManager managingInstance = MouseBindingMouseEventDispatcher.getDockingWindowManagerForWindow(activeWindow);
        if (managingInstance != null) {
            return managingInstance;
        }
        return activeManager;
    }

    private static DockingWindowManager getDockingWindowManagerForWindow(Window activeWindow) {
        DockingWindowManager manager = DockingWindowManager.getInstance(activeWindow);
        if (manager != null) {
            return manager;
        }
        if (activeWindow instanceof DockingDialog) {
            DockingDialog dockingDialog = (DockingDialog)activeWindow;
            return dockingDialog.getOwningWindowManager();
        }
        return null;
    }

    private record PendingActionInfo(DockingMouseBindingAction action, MouseBinding mouseBinding) {
    }
}

