/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfscommon;

import org.catacombae.hfsexplorer.types.hfs.ExtDataRec;
import org.catacombae.hfsexplorer.types.hfs.ExtKeyRec;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentLeafRecord;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentKey;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonHFSExtentLeafNode
extends CommonBTNode<CommonHFSExtentLeafRecord> {
    protected CommonHFSExtentLeafNode(byte[] data, int offset, int nodeSize, CommonBTNode.FSType type) {
        super(data, offset, nodeSize, type);
    }

    public CommonHFSExtentLeafRecord[] getLeafRecords() {
        return this.ic.records.toArray(new CommonHFSExtentLeafRecord[this.ic.records.size()]);
    }

    public static CommonHFSExtentLeafNode createHFS(byte[] data, int offset, int nodeSize) {
        return new HFSImplementation(data, offset, nodeSize);
    }

    public static CommonHFSExtentLeafNode createHFSPlus(byte[] data, int offset, int nodeSize) {
        return new HFSPlusImplementation(data, offset, nodeSize);
    }

    public static class HFSImplementation
    extends CommonHFSExtentLeafNode {
        public HFSImplementation(byte[] data, int offset, int nodeSize) {
            super(data, offset, nodeSize, CommonBTNode.FSType.HFS);
        }

        protected CommonHFSExtentLeafRecord createBTRecord(int recordNumber, byte[] data, int offset, int length) {
            ExtKeyRec key = new ExtKeyRec(data, offset);
            ExtDataRec recordData = new ExtDataRec(data, offset + key.length());
            return CommonHFSExtentLeafRecord.create(key, recordData);
        }
    }

    public static class HFSPlusImplementation
    extends CommonHFSExtentLeafNode {
        public HFSPlusImplementation(byte[] data, int offset, int nodeSize) {
            super(data, offset, nodeSize, CommonBTNode.FSType.HFS_PLUS);
        }

        protected CommonHFSExtentLeafRecord createBTRecord(int recordNumber, byte[] data, int offset, int length) {
            HFSPlusExtentKey key = new HFSPlusExtentKey(data, offset);
            HFSPlusExtentRecord recordData = new HFSPlusExtentRecord(data, offset + key.length());
            return CommonHFSExtentLeafRecord.create(key, recordData);
        }
    }
}

