/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.StatusBarSpacer;
import docking.widgets.EmptyBorderButton;
import docking.widgets.label.GDLabel;
import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.FrontEndTool;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.layout.HorizontalLayout;
import ghidra.util.task.BufferedSwingRunner;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import log.LogListener;
import log.LogPanelAppender;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;

public class LogPanel
extends JPanel
implements LogListener {
    private JButton button;
    private JLabel label;
    private BufferedSwingRunner messageUpdater = new BufferedSwingRunner();

    LogPanel(FrontEndPlugin plugin) {
        super(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(8, 4, 4, 2));
        this.button = new EmptyBorderButton((Icon)new GIcon("icon.console"));
        this.label = new GDLabel();
        this.label.setName("Details");
        panel.add((Component)this.label, "Center");
        JPanel eastPanel = new JPanel((LayoutManager)new HorizontalLayout(0));
        eastPanel.add(this.button);
        eastPanel.add((Component)new StatusBarSpacer());
        panel.add((Component)eastPanel, "East");
        CompoundBorder b = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5), BorderFactory.createLoweredBevelBorder());
        this.label.setBorder(b);
        this.button.setPreferredSize(new Dimension(24, 24));
        this.button.setFocusable(false);
        this.button.setToolTipText("Show Console (Refresh Open Console)");
        this.button.addActionListener(e -> {
            FrontEndTool tool = (FrontEndTool)plugin.getTool();
            tool.showGhidraUserLogFile();
        });
        this.addLogAppender();
        this.add((Component)panel, "North");
    }

    public void setHelpLocation(HelpLocation helpLocation) {
        HelpService help = Help.getHelpService();
        help.registerHelp((Object)this.button, helpLocation);
        this.button.setFocusable(true);
    }

    public void messageLogged(String message, boolean isError) {
        this.messageUpdater.run(() -> {
            this.label.setForeground((Color)(isError ? GThemeDefaults.Colors.Messages.ERROR : GThemeDefaults.Colors.FOREGROUND));
            String text = message.replace("\n", " ");
            this.label.setText(text);
            this.label.setToolTipText(text);
        });
    }

    private void addLogAppender() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LogPanelAppender logAppender = (LogPanelAppender)config.getAppender("logPanel");
        if (logAppender == null) {
            Msg.error((Object)this, (Object)"Couldn't find LogPanelAppender instance in the Log4j context; nothing will be logged to the application's Front-end panel.");
            return;
        }
        logAppender.setLogListener((LogListener)this);
    }
}

