/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import db.DBHandle;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.help.UnsupportedOperationException;

public class URLLinkObject
extends DomainObjectAdapterDB {
    private static final int DB_BUFFER_SIZE = 1024;
    private URL url;

    public URLLinkObject(String name, URL ghidraUrl, Object consumer) throws IOException {
        super(new DBHandle(1024), name, 500, consumer);
        this.metadata.put("link.url", ghidraUrl.toString());
        this.updateMetadata();
    }

    public URLLinkObject(DBHandle dbh, Object consumer) throws IOException {
        super(dbh, "Untitled", 500, consumer);
        this.loadMetadata();
        String urlText = (String)this.metadata.get("link.url");
        if (urlText == null) {
            throw new IOException("Null link object");
        }
        this.url = new URL(urlText);
    }

    @Override
    public String getDescription() {
        return "Link-File";
    }

    public URL getLink() {
        return this.url;
    }

    @Override
    public final boolean isChangeable() {
        return false;
    }

    @Override
    public final void saveToPackedFile(File outputFile, TaskMonitor monitor) throws IOException, CancelledException {
        throw new UnsupportedOperationException();
    }
}

