/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb.DefaultCompositeMember;
import ghidra.app.util.bin.format.pdb.PdbMember;
import ghidra.app.util.bin.format.pdb.WrappedDataType;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.pdb.classtype.Access;
import ghidra.app.util.pdb.classtype.ClassFieldAttributes;
import ghidra.app.util.pdb.classtype.ClassKey;
import ghidra.app.util.pdb.classtype.MsVxtManager;
import ghidra.app.util.pdb.classtype.OwnerParentage;
import ghidra.app.util.pdb.classtype.PlaceholderVirtualBaseTable;
import ghidra.app.util.pdb.classtype.PlaceholderVirtualBaseTableEntry;
import ghidra.app.util.pdb.classtype.ProgramVirtualBaseTable;
import ghidra.app.util.pdb.classtype.VBTableEntry;
import ghidra.app.util.pdb.classtype.VFTableEntry;
import ghidra.app.util.pdb.classtype.VXT;
import ghidra.app.util.pdb.classtype.VirtualBaseTable;
import ghidra.app.util.pdb.classtype.VirtualBaseTableEntry;
import ghidra.app.util.pdb.classtype.VirtualFunctionTable;
import ghidra.app.util.pdb.classtype.VirtualFunctionTableEntry;
import ghidra.app.util.pdb.classtype.VxtManager;
import ghidra.app.util.pdb.pdbapplicator.ObjectOrientedClassLayout;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.gclass.ClassID;
import ghidra.program.model.gclass.ClassUtils;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class CppCompositeType {
    private static final String SELF_BASE_COMMENT = "Self Base";
    private static final String BASE_COMMENT = "Base";
    private static final String VIRTUAL_BASE_COMMENT = "Virtual Base";
    private static final String VIRTUAL_BASE_SPECULATIVE_COMMENT = "Virtual Base - Speculative Placement";
    private boolean isFinal;
    private ClassKey classKey;
    private String className;
    private String mangledName;
    private int size;
    private SymbolPath symbolPath;
    private CategoryPath categoryPath;
    private ClassID myId;
    private CategoryPath baseCategoryPath;
    private CategoryPath internalsCategoryPath;
    private Composite composite;
    private Composite selfBaseType;
    private Map<String, String> vxtPtrSummary;
    private String summarizedClassVxtPtrInfo;
    private List<DirectLayoutBaseClass> directLayoutBaseClasses;
    private List<VirtualLayoutBaseClass> virtualLayoutBaseClasses;
    private List<DirectVirtualLayoutBaseClass> directVirtualLayoutBaseClasses;
    private List<IndirectVirtualLayoutBaseClass> indirectVirtualLayoutBaseClasses;
    private TreeMap<Long, Pointer> vftPtrTypeByOffset;
    private List<AbstractMember> myMembers;
    private List<Member> layoutMembers;
    private List<VirtualFunctionInfo> virtualFunctionInfo;
    private List<SyntacticBaseClass> syntacticBaseClasses;
    private Long myVftPtrOffset;
    private Long myVbtPtrOffset;
    private Long mainVftPtrOffset;
    private Long mainVbtPtrOffset;
    private VirtualFunctionTable mainVft;
    private VirtualBaseTable mainVbt;
    private boolean hasZeroBaseSize;
    private LinkedHashMap<ClassID, List<ClassID>> depthFirstVirtualBases;
    private List<Member> layoutVftPtrMembers;
    private List<Member> layoutVbtPtrMembers;
    private Map<Long, OwnerParentage> vfTableIdByOffset;
    private Map<OwnerParentage, Long> vftOffsetByTableId;
    private Map<Long, OwnerParentage> vbTableIdByOffset;
    private Map<OwnerParentage, Long> vbtOffsetByTableId;
    private TreeMap<ClassID, Long> baseOffsetById;
    private TreeSet<VxtPtrInfo> propagatedSelfBaseVfts;
    private TreeSet<VxtPtrInfo> propagatedSelfBaseVbts;
    private TreeSet<VxtPtrInfo> propagatedDirectVirtualBaseVfts;
    private TreeSet<VxtPtrInfo> propagatedDirectVirtualBaseVbts;
    private TreeSet<VxtPtrInfo> propagatededIndirectVirtualBaseVfts;
    private TreeSet<VxtPtrInfo> propagatedIndirectVirtualBaseVbts;
    private TreeMap<Long, VxtPtrInfo> finalVftPtrInfoByOffset;
    private TreeMap<Long, VxtPtrInfo> finalVbtPtrInfoByOffset;
    private TreeMap<Long, VXT> finalVftByOffset;
    private TreeMap<Long, VXT> finalVbtByOffset;

    public CppCompositeType(CategoryPath baseCategoryPath, SymbolPath symbolPath, Composite composite, String mangledName) {
        Objects.requireNonNull(symbolPath, "symbolPath may not be null");
        Objects.requireNonNull(composite, "composite may not be null");
        this.isFinal = false;
        this.classKey = ClassKey.UNKNOWN;
        this.baseCategoryPath = baseCategoryPath;
        this.symbolPath = symbolPath;
        this.composite = composite;
        this.mangledName = mangledName;
        this.myId = CppCompositeType.getClassId(this);
        this.categoryPath = new CategoryPath(composite.getCategoryPath(), new String[]{composite.getName()});
        this.internalsCategoryPath = ClassUtils.getClassInternalsPath((Composite)composite);
        this.directLayoutBaseClasses = new ArrayList<DirectLayoutBaseClass>();
        this.virtualLayoutBaseClasses = new ArrayList<VirtualLayoutBaseClass>();
        this.directVirtualLayoutBaseClasses = new ArrayList<DirectVirtualLayoutBaseClass>();
        this.indirectVirtualLayoutBaseClasses = new ArrayList<IndirectVirtualLayoutBaseClass>();
        this.virtualFunctionInfo = new ArrayList<VirtualFunctionInfo>();
        this.vftPtrTypeByOffset = new TreeMap();
        this.myMembers = new ArrayList<AbstractMember>();
        this.layoutMembers = new ArrayList<Member>();
        this.syntacticBaseClasses = new ArrayList<SyntacticBaseClass>();
    }

    public void addDirectBaseClass(Composite comp, CppCompositeType baseClassType, int offset) throws PdbException {
        this.addDirectBaseClass(comp, baseClassType, ClassFieldAttributes.UNKNOWN, offset);
    }

    public void addDirectBaseClass(Composite comp, CppCompositeType baseClassType, ClassFieldAttributes attributes, int offset) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        DirectLayoutBaseClass base = new DirectLayoutBaseClass(this, comp, baseClassType, attributes, offset);
        this.directLayoutBaseClasses.add(base);
    }

    public void addDirectVirtualBaseClass(Composite comp, CppCompositeType baseClassType, int basePointerOffset, DataType vbptr, int offsetFromVbt) throws PdbException {
        this.addDirectVirtualBaseClass(comp, baseClassType, ClassFieldAttributes.UNKNOWN, basePointerOffset, vbptr, offsetFromVbt);
    }

    public void addDirectVirtualBaseClass(Composite comp, CppCompositeType baseClassType, ClassFieldAttributes attributes, int basePointerOffset, DataType vbptr, int offsetFromVbt) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        DirectVirtualLayoutBaseClass base = new DirectVirtualLayoutBaseClass(this, comp, baseClassType, attributes, basePointerOffset, vbptr, offsetFromVbt);
        this.directVirtualLayoutBaseClasses.add(base);
        this.virtualLayoutBaseClasses.add(base);
    }

    public void addIndirectVirtualBaseClass(Composite comp, CppCompositeType baseClassType, int basePointerOffset, DataType vbptr, int offsetFromVbt) throws PdbException {
        this.addIndirectVirtualBaseClass(comp, baseClassType, ClassFieldAttributes.UNKNOWN, basePointerOffset, vbptr, offsetFromVbt);
    }

    public void addIndirectVirtualBaseClass(Composite comp, CppCompositeType baseClassType, ClassFieldAttributes attributes, int basePointerOffset, DataType vbptr, int offsetFromVbt) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        IndirectVirtualLayoutBaseClass base = new IndirectVirtualLayoutBaseClass(this, comp, baseClassType, attributes, basePointerOffset, vbptr, offsetFromVbt);
        this.indirectVirtualLayoutBaseClasses.add(base);
        this.virtualLayoutBaseClasses.add(base);
    }

    public void addVirtualFunctionTablePointer(Pointer ptrType, int offset) {
        this.vftPtrTypeByOffset.put(Long.valueOf(offset), ptrType);
    }

    public void addMember(String memberName, DataType dataType, boolean isFlexibleArray, int offset, String comment) {
        this.addMember(memberName, dataType, isFlexibleArray, ClassFieldAttributes.UNKNOWN, offset, comment);
    }

    public void addMember(String memberName, DataType dataType, boolean isFlexibleArray, int offset) {
        this.addMember(memberName, dataType, isFlexibleArray, ClassFieldAttributes.UNKNOWN, offset, null);
    }

    public void addMember(String memberName, DataType dataType, boolean isFlexibleArray, ClassFieldAttributes attributes, int offset) {
        Member newMember = new Member(this, memberName, dataType, isFlexibleArray, attributes, offset);
        this.myMembers.add(newMember);
        this.addMember(this.layoutMembers, newMember);
    }

    public void addMember(String memberName, DataType dataType, boolean isFlexibleArray, ClassFieldAttributes attributes, int offset, String comment) {
        Member newMember = new Member(this, memberName, dataType, isFlexibleArray, attributes, offset, comment);
        this.myMembers.add(newMember);
        this.addMember(this.layoutMembers, newMember);
    }

    public void addVirtualMethod(int thisAdjuster, int tableOffset, SymbolPath name, FunctionDefinition definition) {
        VirtualFunctionInfo info = new VirtualFunctionInfo(tableOffset, thisAdjuster, name, definition);
        this.virtualFunctionInfo.add(info);
    }

    public void createLayout(ObjectOrientedClassLayout layoutOptions, MsVxtManager vxtManager, TaskMonitor monitor) throws PdbException, CancelledException {
        switch (layoutOptions) {
            case MEMBERS_ONLY: {
                this.createMembersOnlyClassLayout(monitor);
                break;
            }
            case CLASS_HIERARCHY: 
            case CLASS_HIERARCHY_SPECULATIVE: {
                this.createHierarchicalClassLayout(vxtManager, layoutOptions, monitor);
            }
        }
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setClass() {
        this.classKey = ClassKey.CLASS;
    }

    public void setStruct() {
        this.classKey = ClassKey.STRUCT;
    }

    public void setUnion() {
        this.classKey = ClassKey.UNION;
    }

    public ClassKey getKey() {
        return this.classKey;
    }

    public Access getDefaultAccess() {
        return ClassKey.CLASS.equals((Object)this.classKey) ? Access.PRIVATE : Access.PUBLIC;
    }

    public void setName(String className) {
        this.className = className;
    }

    public String getName() {
        return this.className;
    }

    public DataTypePath getDataTypePath() {
        return this.composite.getDataTypePath();
    }

    public void setMangledName(String mangledName) {
        this.mangledName = mangledName;
    }

    public String getMangledName() {
        return this.mangledName;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.classKey);
        builder.append(this.className);
        if (this.isFinal) {
            builder.append(" final");
        }
        StringBuilder baseBuilder = new StringBuilder();
        for (BaseClass baseClass : this.syntacticBaseClasses) {
            if (baseBuilder.length() == 0) {
                baseBuilder.append(" : ");
            } else {
                baseBuilder.append(", ");
            }
            baseBuilder.append(baseClass);
        }
        builder.append((CharSequence)baseBuilder);
        return builder.toString();
    }

    public SymbolPath getSymbolPath() {
        return this.symbolPath;
    }

    public ClassID getClassId() {
        return this.myId;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public Composite getSelfBaseType() {
        return this.selfBaseType;
    }

    public CategoryPath getCategoryPath() {
        return this.categoryPath;
    }

    public CategoryPath getInternalsCategoryPath() {
        return this.internalsCategoryPath;
    }

    String getSummarizedClassVxtPtrInfo() {
        if (this.vxtPtrSummary.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Class: %s\n", this.getSymbolPath().toString()));
        for (String value : this.vxtPtrSummary.values()) {
            builder.append(value);
        }
        return builder.toString();
    }

    Map<String, String> getVxtPtrSummary() {
        return this.vxtPtrSummary;
    }

    public DataTypePath getSelfBaseDataTypePath(String baseName) {
        return new DataTypePath(this.getInternalsCategoryPath(), baseName);
    }

    public DataTypePath getVBTableDataTypePath(int offset) {
        return new DataTypePath(this.getInternalsCategoryPath(), String.format("Vbtable_%08x", offset));
    }

    public DataTypePath getVFTableDataTypePath(int offset) {
        return new DataTypePath(this.getInternalsCategoryPath(), String.format("Vftable_%08x", offset));
    }

    private static void validateBaseClass(CppCompositeType baseClassType) throws PdbException {
        if (baseClassType.isFinal) {
            throw new PdbException("Cannot inherit base class marked final.");
        }
    }

    private void addMember(List<Member> members, Member newMember) {
        members.add(newMember);
    }

    public static CppClassType createCppClassType(CategoryPath baseCategoryPath, SymbolPath symbolPath, Composite composite, String mangledName) {
        return new CppClassType(baseCategoryPath, symbolPath, composite, mangledName);
    }

    public static CppClassType createCppClassType(CategoryPath baseCategoryPath, SymbolPath symbolPath, Composite composite, String name, String mangledName, int size) {
        CppClassType cppType = new CppClassType(baseCategoryPath, symbolPath, composite, mangledName);
        cppType.setName(name);
        cppType.setSize(size);
        return cppType;
    }

    public static CppStructType createCppStructType(CategoryPath baseCategoryPath, SymbolPath symbolPath, Composite composite, String mangledName) {
        return new CppStructType(baseCategoryPath, symbolPath, composite, mangledName);
    }

    public static CppStructType createCppStructType(CategoryPath baseCategoryPath, SymbolPath symbolPath, Composite composite, String name, String mangledName, int size) {
        CppStructType cppType = new CppStructType(baseCategoryPath, symbolPath, composite, mangledName);
        cppType.setName(name);
        cppType.setSize(size);
        return cppType;
    }

    private static DataTypePath createSelfBaseCategoryPath(CppCompositeType cppType) {
        return cppType.getSelfBaseDataTypePath(cppType.getComposite().getName());
    }

    private static ClassID getClassId(CppCompositeType cpp) {
        return new ClassID(cpp.baseCategoryPath, cpp.getSymbolPath());
    }

    static boolean validateMangledCompositeName(String mangledCompositeTypeName, ClassKey key) {
        if (mangledCompositeTypeName == null) {
            return false;
        }
        if (!mangledCompositeTypeName.startsWith(".?")) {
            return false;
        }
        if (mangledCompositeTypeName.length() < 7) {
            return false;
        }
        if (mangledCompositeTypeName.charAt(2) != 'A') {
            PdbLog.message("Mangled composite type name not plain 'A'");
        }
        switch (mangledCompositeTypeName.charAt(3)) {
            case 'T': {
                if (key.compareTo(ClassKey.UNION) == 0 || key.compareTo(ClassKey.UNKNOWN) == 0) break;
                PdbLog.message("Warning: Mismatched complex type 'T' for " + String.valueOf((Object)key));
                break;
            }
            case 'U': {
                if (key.compareTo(ClassKey.STRUCT) == 0 || key.compareTo(ClassKey.UNKNOWN) == 0) break;
                PdbLog.message("Warning: Mismatched complex type 'U' for " + String.valueOf((Object)key));
                break;
            }
            case 'V': {
                if (key.compareTo(ClassKey.CLASS) == 0 || key.compareTo(ClassKey.UNKNOWN) == 0) break;
                PdbLog.message("Warning: Mismatched complex type 'V' for " + String.valueOf((Object)key));
                break;
            }
            default: {
                PdbLog.message("Not composite");
                return false;
            }
        }
        return true;
    }

    public boolean validate() {
        return !StringUtils.isEmpty((CharSequence)this.className) || this.isFinal;
    }

    private TreeSet<VxtPtrInfo> getPropagatedSelfBaseVfts() {
        return this.propagatedSelfBaseVfts;
    }

    private TreeSet<VxtPtrInfo> getPropagatedSelfBaseVbts() {
        return this.propagatedSelfBaseVbts;
    }

    private TreeSet<VxtPtrInfo> getPropagatedDirectVirtualBaseVfts() {
        return this.propagatedDirectVirtualBaseVfts;
    }

    private TreeSet<VxtPtrInfo> getPropagatedDirectVirtualBaseVbts() {
        return this.propagatedDirectVirtualBaseVbts;
    }

    private TreeSet<VxtPtrInfo> getPropagatedIndirectVirtualBaseVfts() {
        return this.propagatededIndirectVirtualBaseVfts;
    }

    private TreeSet<VxtPtrInfo> getPropagatedIndirectVirtualBaseVbts() {
        return this.propagatedIndirectVirtualBaseVbts;
    }

    private void createHierarchicalClassLayout(MsVxtManager vxtManager, ObjectOrientedClassLayout layoutOptions, TaskMonitor monitor) throws PdbException, CancelledException {
        this.initLayoutAlgorithmData();
        this.findDirectBaseVxtPtrs(vxtManager);
        this.findOrAllocateMainVftPtr(vxtManager);
        this.findOrAllocateMainVbtPtr(vxtManager);
        this.createClassLayout(vxtManager, layoutOptions, monitor);
        this.finalizeAllVxtParentage();
    }

    private void initLayoutAlgorithmData() {
        this.layoutVftPtrMembers = new ArrayList<Member>();
        this.layoutVbtPtrMembers = new ArrayList<Member>();
        this.vfTableIdByOffset = new HashMap<Long, OwnerParentage>();
        this.vftOffsetByTableId = new HashMap<OwnerParentage, Long>();
        this.vbTableIdByOffset = new HashMap<Long, OwnerParentage>();
        this.vbtOffsetByTableId = new HashMap<OwnerParentage, Long>();
        this.baseOffsetById = new TreeMap();
        this.propagatedSelfBaseVfts = new TreeSet();
        this.propagatedSelfBaseVbts = new TreeSet();
        this.propagatedDirectVirtualBaseVfts = new TreeSet();
        this.propagatedDirectVirtualBaseVbts = new TreeSet();
        this.propagatededIndirectVirtualBaseVfts = new TreeSet();
        this.propagatedIndirectVirtualBaseVbts = new TreeSet();
        this.finalVftPtrInfoByOffset = new TreeMap();
        this.finalVbtPtrInfoByOffset = new TreeMap();
        this.finalVftByOffset = new TreeMap();
        this.finalVbtByOffset = new TreeMap();
        this.vxtPtrSummary = new TreeMap<String, String>();
    }

    private void finalizeAllVxtParentage() {
        String result;
        List<ClassID> altParentage;
        String name;
        PNode parentToChildNode;
        PNode childToParentNode;
        List<ClassID> parentage;
        PNode vbtChildToParentRoot = new PNode(null);
        PNode vbtParentToChildRoot = new PNode(null);
        PNode vftChildToParentRoot = new PNode(null);
        PNode vftParentToChildRoot = new PNode(null);
        for (VxtPtrInfo info : this.finalVftPtrInfoByOffset.values()) {
            parentage = info.parentage();
            childToParentNode = vftChildToParentRoot;
            parentToChildNode = vftParentToChildRoot;
            for (ClassID id : parentage) {
                name = id.getSymbolPath().toString();
                childToParentNode.incrementPathCount();
                childToParentNode = childToParentNode.getOrAddBranch(name);
            }
            for (ClassID id : parentage.reversed()) {
                name = id.getSymbolPath().toString();
                parentToChildNode.incrementPathCount();
                parentToChildNode = parentToChildNode.getOrAddBranch(name);
            }
        }
        for (VxtPtrInfo info : this.finalVbtPtrInfoByOffset.values()) {
            parentage = info.parentage();
            childToParentNode = vbtChildToParentRoot;
            parentToChildNode = vbtParentToChildRoot;
            for (ClassID id : parentage) {
                name = id.getSymbolPath().toString();
                childToParentNode.incrementPathCount();
                childToParentNode = childToParentNode.getOrAddBranch(name);
            }
            for (ClassID id : parentage.reversed()) {
                name = id.getSymbolPath().toString();
                parentToChildNode.incrementPathCount();
                parentToChildNode = parentToChildNode.getOrAddBranch(name);
            }
        }
        StringBuilder builder = new StringBuilder();
        TreeMap<String, String> results = new TreeMap<String, String>();
        for (VxtPtrInfo info : this.finalVftPtrInfoByOffset.values()) {
            altParentage = this.finalizeVxtPtrParentage(vftChildToParentRoot, vftParentToChildRoot, info);
            name = ClassUtils.getSpecialVxTableName((long)info.finalOffset);
            result = this.dumpVxtPtrResult("vft", info, (List<ClassID>)altParentage.reversed());
            builder.append(result + "\n");
            results.put(name, result);
        }
        for (VxtPtrInfo info : this.finalVbtPtrInfoByOffset.values()) {
            altParentage = this.finalizeVxtPtrParentage(vbtChildToParentRoot, vbtParentToChildRoot, info);
            name = ClassUtils.getSpecialVxTableName((long)info.finalOffset);
            result = this.dumpVxtPtrResult("vbt", info, (List<ClassID>)altParentage.reversed());
            builder.append(result + "\n");
            results.put(name, result);
        }
        if (!builder.isEmpty()) {
            builder.insert(0, String.format("Class: %s\n", this.getSymbolPath().toString()));
        }
        this.summarizedClassVxtPtrInfo = builder.toString();
        this.vxtPtrSummary = results;
    }

    private List<ClassID> finalizeVxtPtrParentage(PNode childToParentNode, PNode parentToChildNode, VxtPtrInfo info) {
        List<ClassID> parentage = info.parentage();
        ArrayList<ClassID> altParentage = new ArrayList<ClassID>();
        String startNode = null;
        for (ClassID id : parentage) {
            String name = id.getSymbolPath().toString();
            if ((childToParentNode = childToParentNode.getBranch(name)).getPathCount() != 1) continue;
            startNode = name;
            break;
        }
        boolean foundStart = startNode == null;
        for (ClassID id : parentage.reversed()) {
            String name = id.getSymbolPath().toString();
            if (name.equals(startNode)) {
                foundStart = true;
            }
            if (parentToChildNode.getPathCount() <= 1) break;
            if (foundStart) {
                altParentage.addFirst(id);
            }
            parentToChildNode = parentToChildNode.getBranch(name);
        }
        return altParentage;
    }

    private String dumpVxtPtrResult(String vxt, VxtPtrInfo info, List<ClassID> altParentage) {
        ArrayList<String> r1 = new ArrayList<String>();
        for (ClassID id : altParentage.reversed()) {
            String name = id.getSymbolPath().toString();
            r1.add(name);
        }
        ArrayList<String> r2 = new ArrayList<String>();
        for (ClassID id : info.parentage().reversed()) {
            String name = id.getSymbolPath().toString();
            r2.add(name);
        }
        return String.format("  %4d %s %s\t%s", info.finalOffset(), vxt, ((Object)r1).toString(), ((Object)r2).toString());
    }

    private void createSelfBase() {
        DataTypePath selfBasePath = CppCompositeType.createSelfBaseCategoryPath(this);
        this.selfBaseType = new StructureDataType(selfBasePath.getCategoryPath(), selfBasePath.getDataTypeName(), 0, this.composite.getDataTypeManager());
        this.selfBaseType.setDescription("Base of " + selfBasePath.getDataTypeName());
    }

    private void createMembersOnlyClassLayout(TaskMonitor monitor) throws CancelledException {
        ArrayList<ClassPdbMember> pdbMembers = new ArrayList<ClassPdbMember>();
        for (Member member : this.layoutMembers) {
            ClassPdbMember classPdbMember = new ClassPdbMember(member.getName(), member.getDataType(), member.isFlexibleArray(), member.getOffset(), member.getComment());
            pdbMembers.add(classPdbMember);
        }
        if (!DefaultCompositeMember.applyDataTypeMembers(this.composite, false, false, this.size, pdbMembers, msg -> Msg.warn((Object)this, (Object)msg), monitor)) {
            CppCompositeType.clearComponents(this.composite);
        }
        this.selfBaseType = this.composite;
    }

    private void createClassLayout(MsVxtManager vxtManager, ObjectOrientedClassLayout layoutOptions, TaskMonitor monitor) throws CancelledException, PdbException {
        List<ClassPdbMember> selfBaseMembers = this.getSelfBaseClassMembers();
        this.mainVft = this.getMainVft(vxtManager);
        if (this.mainVft != null) {
            this.updateMainVft();
        }
        if (this.getNumLayoutVirtualBaseClasses() == 0) {
            if (!DefaultCompositeMember.applyDataTypeMembers(this.composite, false, false, this.size, selfBaseMembers, msg -> Msg.warn((Object)this, (Object)msg), monitor)) {
                CppCompositeType.clearComponents(this.composite);
            }
            this.selfBaseType = this.composite;
        } else {
            this.createSelfBase();
            if (!DefaultCompositeMember.applyDataTypeMembers(this.selfBaseType, false, false, 0, selfBaseMembers, msg -> Msg.warn((Object)this, (Object)msg), monitor)) {
                CppCompositeType.clearComponents(this.composite);
            }
            ClassPdbMember directClassPdbMember = new ClassPdbMember("", (DataType)this.selfBaseType, false, 0, SELF_BASE_COMMENT);
            this.mainVbt = this.getMainVbt(vxtManager);
            if (this.mainVbt != null) {
                this.updateMainVbt();
            }
            TreeMap<Long, ClassPdbMember> allMembers = new TreeMap<Long, ClassPdbMember>();
            allMembers.put(0L, directClassPdbMember);
            TreeMap<Long, ClassPdbMember> virtualBasePdbMembers = this.processVirtualBaseClasses(vxtManager, layoutOptions);
            allMembers.putAll(virtualBasePdbMembers);
            ArrayList am = new ArrayList(allMembers.values());
            if (!DefaultCompositeMember.applyDataTypeMembers(this.composite, false, false, this.size, am, msg -> Msg.warn((Object)this, (Object)msg), monitor)) {
                CppCompositeType.clearComponents(this.composite);
            }
        }
        for (VXT t : this.finalVftByOffset.values()) {
            VirtualFunctionTable vft = (VirtualFunctionTable)t;
            this.updateVftFromSelf(vft);
        }
    }

    private static final void clearComponents(Composite composite) {
        if (composite instanceof Structure) {
            ((Structure)composite).deleteAll();
        } else {
            while (composite.getNumComponents() > 0) {
                composite.delete(0);
            }
        }
    }

    private boolean hasZeroBaseSize() {
        return this.hasZeroBaseSize;
    }

    private List<ClassPdbMember> getSelfBaseClassMembers() {
        ClassPdbMember member;
        ClassPdbMember classPdbMember;
        this.hasZeroBaseSize = true;
        ArrayList<ClassPdbMember> members = new ArrayList<ClassPdbMember>();
        Object accumulatedComment = "";
        for (DirectLayoutBaseClass base : this.directLayoutBaseClasses) {
            Object comment;
            CppCompositeType baseComposite = base.getBaseClassType();
            if (!baseComposite.hasZeroBaseSize()) {
                this.hasZeroBaseSize = false;
                comment = BASE_COMMENT;
                if (!((String)accumulatedComment).isEmpty()) {
                    comment = (String)comment + " and previous " + (String)accumulatedComment;
                }
                Composite baseDataType = base.getSelfBaseDataType();
                int offset = base.getOffset();
                ClassPdbMember classPdbMember2 = new ClassPdbMember("", (DataType)baseDataType, false, offset, (String)comment);
                members.add(classPdbMember2);
                accumulatedComment = "";
                continue;
            }
            comment = "(Empty Base " + base.getDataTypePath().getDataTypeName() + ")";
            accumulatedComment = (String)accumulatedComment + (String)comment;
        }
        this.hasZeroBaseSize &= this.layoutVftPtrMembers.size() == 0;
        this.hasZeroBaseSize &= this.layoutVbtPtrMembers.size() == 0;
        this.hasZeroBaseSize &= this.layoutMembers.size() == 0;
        for (Member member2 : this.layoutMembers) {
            classPdbMember = new ClassPdbMember(member2.getName(), member2.getDataType(), member2.isFlexibleArray(), member2.getOffset(), member2.getComment());
            members.add(classPdbMember);
        }
        for (Member vftMember : this.layoutVftPtrMembers) {
            classPdbMember = new ClassPdbMember(vftMember.getName(), vftMember.getDataType(), vftMember.isFlexibleArray(), vftMember.getOffset(), vftMember.getComment());
            int vOff = vftMember.getOffset();
            int index = 0;
            Iterator iterator = members.iterator();
            while (iterator.hasNext() && (member = (ClassPdbMember)iterator.next()).getOffset() < vOff) {
                ++index;
            }
            members.add(index, classPdbMember);
        }
        for (Member vbtMember : this.layoutVbtPtrMembers) {
            classPdbMember = new ClassPdbMember(vbtMember.getName(), vbtMember.getDataType(), vbtMember.isFlexibleArray(), vbtMember.getOffset(), vbtMember.getComment());
            int vOff = vbtMember.getOffset();
            int index = 0;
            Iterator iterator = members.iterator();
            while (iterator.hasNext() && (member = (ClassPdbMember)iterator.next()).getOffset() < vOff) {
                ++index;
            }
            members.add(index, classPdbMember);
        }
        return members;
    }

    private TreeMap<Long, ClassPdbMember> getVirtualBaseClassMembers(String baseComment) {
        TreeMap<Long, ClassPdbMember> map = new TreeMap<Long, ClassPdbMember>();
        Object accumulatedComment = "";
        for (VirtualLayoutBaseClass base : this.virtualLayoutBaseClasses) {
            Object comment;
            CppCompositeType baseComposite = base.getBaseClassType();
            ClassID id = baseComposite.getClassId();
            Long offset = this.baseOffsetById.get(id);
            if (!baseComposite.hasZeroBaseSize()) {
                comment = baseComment;
                if (!((String)accumulatedComment).isEmpty()) {
                    comment = (String)comment + " and previous " + (String)accumulatedComment;
                }
                Composite baseDataType = base.getSelfBaseDataType();
                ClassPdbMember classPdbMember = new ClassPdbMember("", (DataType)baseDataType, false, offset.intValue(), (String)comment);
                map.put(offset, classPdbMember);
                accumulatedComment = "";
                continue;
            }
            comment = "(Empty Virtual Base " + base.getDataTypePath().getDataTypeName() + ")";
            accumulatedComment = (String)accumulatedComment + (String)comment;
        }
        return map;
    }

    private void findDirectBaseVxtPtrs(VxtManager vxtManager) {
        for (DirectLayoutBaseClass base : this.directLayoutBaseClasses) {
            VxtPtrInfo newInfo;
            CppCompositeType cppBaseType = base.getBaseClassType();
            ClassID baseId = cppBaseType.getClassId();
            long baseOffset = base.getOffset();
            if (cppBaseType.getPropagatedSelfBaseVfts() != null) {
                for (VxtPtrInfo parentInfo : cppBaseType.getPropagatedSelfBaseVfts()) {
                    newInfo = this.createSelfOwnedDirectVxtPtrInfo(parentInfo, baseId, baseOffset);
                    this.updateVft(vxtManager, baseId, newInfo, parentInfo);
                    this.storeVxtInfo(this.propagatedSelfBaseVfts, this.finalVftPtrInfoByOffset, this.vfTableIdByOffset, this.vftOffsetByTableId, newInfo);
                }
            }
            if (cppBaseType.getPropagatedSelfBaseVbts() == null) continue;
            for (VxtPtrInfo parentInfo : cppBaseType.getPropagatedSelfBaseVbts()) {
                newInfo = this.createSelfOwnedDirectVxtPtrInfo(parentInfo, baseId, baseOffset);
                this.updateVbt(vxtManager, baseId, newInfo, parentInfo);
                this.storeVxtInfo(this.propagatedSelfBaseVbts, this.finalVbtPtrInfoByOffset, this.vbTableIdByOffset, this.vbtOffsetByTableId, newInfo);
            }
        }
    }

    private void findVirtualBaseVxtPtrs(MsVxtManager vxtManager) throws PdbException {
        VxtPtrInfo newInfo;
        ClassID baseId;
        CppCompositeType cppBaseType;
        for (DirectLayoutBaseClass directLayoutBaseClass : this.directLayoutBaseClasses) {
            cppBaseType = directLayoutBaseClass.getBaseClassType();
            baseId = cppBaseType.getClassId();
            for (VxtPtrInfo info : cppBaseType.getPropagatedDirectVirtualBaseVfts()) {
                newInfo = this.createSelfOwnedVirtualVxtPtrInfo(info);
                this.updateVft(vxtManager, baseId, newInfo, info);
                this.storeVxtInfo(this.propagatedDirectVirtualBaseVfts, this.finalVftPtrInfoByOffset, this.vfTableIdByOffset, this.vftOffsetByTableId, newInfo);
            }
            for (VxtPtrInfo info : cppBaseType.getPropagatedDirectVirtualBaseVbts()) {
                newInfo = this.createSelfOwnedVirtualVxtPtrInfo(info);
                this.updateVbt(vxtManager, baseId, newInfo, info);
                this.storeVxtInfo(this.propagatedDirectVirtualBaseVbts, this.finalVbtPtrInfoByOffset, this.vbTableIdByOffset, this.vbtOffsetByTableId, newInfo);
            }
            for (VxtPtrInfo info : cppBaseType.getPropagatedIndirectVirtualBaseVfts()) {
                newInfo = this.createSelfOwnedVirtualVxtPtrInfo(info);
                this.updateVft(vxtManager, baseId, newInfo, info);
                this.storeVxtInfo(this.propagatededIndirectVirtualBaseVfts, this.finalVftPtrInfoByOffset, this.vfTableIdByOffset, this.vftOffsetByTableId, newInfo);
            }
            for (VxtPtrInfo info : cppBaseType.getPropagatedIndirectVirtualBaseVbts()) {
                newInfo = this.createSelfOwnedVirtualVxtPtrInfo(info);
                this.updateVbt(vxtManager, baseId, newInfo, info);
                this.storeVxtInfo(this.propagatedIndirectVirtualBaseVbts, this.finalVbtPtrInfoByOffset, this.vbTableIdByOffset, this.vbtOffsetByTableId, newInfo);
            }
        }
        for (DirectVirtualLayoutBaseClass directVirtualLayoutBaseClass : this.directVirtualLayoutBaseClasses) {
            cppBaseType = directVirtualLayoutBaseClass.getBaseClassType();
            baseId = cppBaseType.getClassId();
            for (VxtPtrInfo info : cppBaseType.getPropagatedSelfBaseVfts()) {
                newInfo = this.createVirtualOwnedSelfVxtPtrInfo(info, baseId);
                this.updateVft(vxtManager, baseId, newInfo, info);
                this.storeVxtInfo(this.propagatedDirectVirtualBaseVfts, this.finalVftPtrInfoByOffset, this.vfTableIdByOffset, this.vftOffsetByTableId, newInfo);
            }
            for (VxtPtrInfo info : cppBaseType.getPropagatedSelfBaseVbts()) {
                newInfo = this.createVirtualOwnedSelfVxtPtrInfo(info, baseId);
                this.updateVbt(vxtManager, baseId, newInfo, info);
                this.storeVxtInfo(this.propagatedDirectVirtualBaseVbts, this.finalVbtPtrInfoByOffset, this.vbTableIdByOffset, this.vbtOffsetByTableId, newInfo);
            }
            for (VxtPtrInfo info : cppBaseType.getPropagatedDirectVirtualBaseVfts()) {
                newInfo = this.createVirtualOwnedVirtualVxtPtrInfo(info);
                this.updateVft(vxtManager, baseId, newInfo, info);
                this.storeVxtInfo(this.propagatededIndirectVirtualBaseVfts, this.finalVftPtrInfoByOffset, this.vfTableIdByOffset, this.vftOffsetByTableId, newInfo);
            }
            for (VxtPtrInfo info : cppBaseType.getPropagatedDirectVirtualBaseVbts()) {
                newInfo = this.createVirtualOwnedVirtualVxtPtrInfo(info);
                this.updateVbt(vxtManager, baseId, newInfo, info);
                this.storeVxtInfo(this.propagatedIndirectVirtualBaseVbts, this.finalVbtPtrInfoByOffset, this.vbTableIdByOffset, this.vbtOffsetByTableId, newInfo);
            }
            for (VxtPtrInfo info : cppBaseType.getPropagatedIndirectVirtualBaseVfts()) {
                newInfo = this.createVirtualOwnedVirtualVxtPtrInfo(info);
                this.updateVft(vxtManager, baseId, newInfo, info);
                this.storeVxtInfo(this.propagatededIndirectVirtualBaseVfts, this.finalVftPtrInfoByOffset, this.vfTableIdByOffset, this.vftOffsetByTableId, newInfo);
            }
            for (VxtPtrInfo info : cppBaseType.getPropagatedIndirectVirtualBaseVbts()) {
                newInfo = this.createVirtualOwnedVirtualVxtPtrInfo(info);
                this.updateVbt(vxtManager, baseId, newInfo, info);
                this.storeVxtInfo(this.propagatedIndirectVirtualBaseVbts, this.finalVbtPtrInfoByOffset, this.vbTableIdByOffset, this.vbtOffsetByTableId, newInfo);
            }
        }
    }

    private void storeVxtInfo(TreeSet<VxtPtrInfo> propagate, TreeMap<Long, VxtPtrInfo> finalInfo, Map<Long, OwnerParentage> tableIdByOffset, Map<OwnerParentage, Long> offsetByTableId, VxtPtrInfo info) {
        propagate.add(info);
        Long finalOffset = info.finalOffset();
        finalInfo.putIfAbsent(finalOffset, info);
        OwnerParentage op = new OwnerParentage(info.baseId(), info.parentage());
        tableIdByOffset.put(finalOffset, op);
        offsetByTableId.put(op, finalOffset);
    }

    private VxtPtrInfo createSelfOwnedDirectVxtPtrInfo(VxtPtrInfo baseInfo, ClassID baseId, long baseOffset) {
        Long accumOffset = baseInfo.accumOffset() + baseOffset;
        return new VxtPtrInfo(accumOffset, accumOffset, baseId, this.updateParentage(baseInfo));
    }

    private VxtPtrInfo createSelfOwnedVirtualVxtPtrInfo(VxtPtrInfo baseInfo) {
        Long accumOffset = baseInfo.accumOffset();
        Long finalOffset = accumOffset + this.baseOffsetById.get(baseInfo.baseId());
        return new VxtPtrInfo(finalOffset, accumOffset, baseInfo.baseId(), this.updateParentage(baseInfo));
    }

    private VxtPtrInfo createVirtualOwnedSelfVxtPtrInfo(VxtPtrInfo baseInfo, ClassID baseId) {
        Long accumOffset = baseInfo.accumOffset();
        Long finalOffset = accumOffset + this.baseOffsetById.get(baseId);
        return new VxtPtrInfo(finalOffset, accumOffset, baseId, this.updateParentage(baseInfo));
    }

    private VxtPtrInfo createVirtualOwnedVirtualVxtPtrInfo(VxtPtrInfo baseInfo) throws PdbException {
        Long accumOffset = baseInfo.accumOffset();
        Long baseOffset = this.baseOffsetById.get(baseInfo.baseId());
        if (baseOffset == null) {
            throw new PdbException("Cannot find base offset");
        }
        Long finalOffset = accumOffset + baseOffset;
        return new VxtPtrInfo(finalOffset, accumOffset, baseInfo.baseId(), this.updateParentage(baseInfo));
    }

    private List<ClassID> updateParentage(VxtPtrInfo info) {
        ArrayList<ClassID> newParentage = new ArrayList<ClassID>(info.parentage());
        newParentage.add(this.myId);
        return newParentage;
    }

    private TreeMap<Long, ClassPdbMember> processVirtualBaseClasses(MsVxtManager vxtManager, ObjectOrientedClassLayout layoutOptions) throws PdbException {
        TreeMap<Long, ClassPdbMember> virtualBasePdbMembers;
        VirtualBaseTable virtualBaseTable = this.mainVbt;
        if (virtualBaseTable instanceof PlaceholderVirtualBaseTable) {
            PlaceholderVirtualBaseTable pvbt = (PlaceholderVirtualBaseTable)virtualBaseTable;
            if (layoutOptions == ObjectOrientedClassLayout.CLASS_HIERARCHY && this.virtualLayoutBaseClasses.size() > 0) {
                virtualBasePdbMembers = this.provideVirtualBaseFillerBytes();
                return virtualBasePdbMembers;
            }
        }
        this.assignVirtualBaseOffsets();
        String baseComment = this.mainVbt instanceof ProgramVirtualBaseTable ? VIRTUAL_BASE_COMMENT : VIRTUAL_BASE_SPECULATIVE_COMMENT;
        virtualBasePdbMembers = this.getVirtualBaseClassMembers(baseComment);
        this.findVirtualBaseVxtPtrs(vxtManager);
        return virtualBasePdbMembers;
    }

    private TreeMap<Long, ClassPdbMember> provideVirtualBaseFillerBytes() throws PdbException {
        TreeMap<Long, ClassPdbMember> fillerForVirtualBasePdbMembers = new TreeMap<Long, ClassPdbMember>();
        int numVirtualBases = this.virtualLayoutBaseClasses.size();
        if (numVirtualBases == 0) {
            return fillerForVirtualBasePdbMembers;
        }
        int offset = this.selfBaseType.getLength();
        int fillerSize = this.size - offset;
        StringBuilder builder = new StringBuilder();
        builder.append("Filler for " + numVirtualBases + " Unplaceable Virtual Base");
        builder.append(numVirtualBases == 1 ? ":" : "s:");
        boolean first = true;
        for (VirtualLayoutBaseClass base : this.virtualLayoutBaseClasses) {
            CppCompositeType cppBaseType = base.getBaseClassType();
            if (!first) {
                builder.append(";");
            }
            first = false;
            builder.append(" ");
            builder.append(cppBaseType.getName());
        }
        String comment = builder.toString();
        ArrayDataType fillerDataType = new ArrayDataType((DataType)CharDataType.dataType, fillerSize);
        boolean isFlexArray = fillerSize == 0;
        ClassPdbMember fillerPdbMember = new ClassPdbMember("", (DataType)fillerDataType, isFlexArray, offset, comment);
        fillerForVirtualBasePdbMembers.put(Long.valueOf(offset), fillerPdbMember);
        return fillerForVirtualBasePdbMembers;
    }

    private void assignVirtualBaseOffsets() throws PdbException {
        for (VirtualLayoutBaseClass base : this.virtualLayoutBaseClasses) {
            CppCompositeType cppBaseType = base.getBaseClassType();
            Long baseOffset = this.mainVbt.getBaseOffset(base.getOffetFromVbt());
            if (baseOffset == null) {
                throw new PdbException("Cannot place base class");
            }
            baseOffset = baseOffset + (long)base.getBasePointerOffset();
            ClassID baseId = cppBaseType.getClassId();
            this.baseOffsetById.put(baseId, baseOffset);
        }
    }

    private void findOrAllocateMainVftPtr(MsVxtManager vxtManager) {
        if (this.propagatedSelfBaseVfts.isEmpty() && !this.vftPtrTypeByOffset.isEmpty()) {
            if (this.vftPtrTypeByOffset.size() > 1) {
                Msg.warn((Object)this, (Object)("Unexpected multiple vfts for " + String.valueOf(this.myId)));
            }
            this.myVftPtrOffset = this.vftPtrTypeByOffset.firstKey();
            VxtPtrInfo info = new VxtPtrInfo(this.myVftPtrOffset, this.myVftPtrOffset, this.myId, List.of(this.myId));
            VirtualFunctionTable myVft = vxtManager.findVft(this.myId, info.parentage(), 0);
            myVft.setPtrOffsetInClass(info.finalOffset());
            this.propagatedSelfBaseVfts.add(info);
            this.finalVftByOffset.put(info.finalOffset(), myVft);
            this.finalVftPtrInfoByOffset.put(info.accumOffset(), info);
            OwnerParentage op = new OwnerParentage(info.baseId(), info.parentage());
            this.vfTableIdByOffset.put(info.accumOffset(), op);
            this.vftOffsetByTableId.put(op, info.accumOffset());
            Member newMember = new Member(this, "{vfptr}", (DataType)ClassUtils.VXPTR_TYPE, false, ClassFieldAttributes.UNKNOWN, this.myVftPtrOffset.intValue());
            this.layoutVftPtrMembers.add(newMember);
            this.myMembers.add(newMember);
        }
        this.mainVftPtrOffset = this.finalVftPtrInfoByOffset.isEmpty() ? null : this.finalVftPtrInfoByOffset.firstKey();
    }

    private void findOrAllocateMainVbtPtr(MsVxtManager vxtManager) {
        if (this.propagatedSelfBaseVbts.isEmpty() && !this.virtualLayoutBaseClasses.isEmpty()) {
            TreeSet<Long> vbtOffsets = new TreeSet<Long>();
            for (VirtualLayoutBaseClass base : this.virtualLayoutBaseClasses) {
                vbtOffsets.add(Long.valueOf(base.getBasePointerOffset()));
            }
            if (vbtOffsets.size() > 1) {
                Msg.warn((Object)this, (Object)("Unexpected multiple vbts for " + String.valueOf(this.myId)));
            }
            Long vbtPtrOffset = (Long)vbtOffsets.first();
            if (this.myVbtPtrOffset != null && vbtPtrOffset != this.myVbtPtrOffset) {
                Msg.warn((Object)this, (Object)("Mismatch vbt location for " + String.valueOf(this.myId)));
            }
            VxtPtrInfo info = new VxtPtrInfo(vbtPtrOffset, vbtPtrOffset, this.myId, List.of(this.myId));
            VirtualBaseTable myVbt = vxtManager.findVbt(this.myId, info.parentage(), 0);
            myVbt.setPtrOffsetInClass(info.finalOffset());
            this.propagatedSelfBaseVbts.add(info);
            this.finalVbtByOffset.put(info.finalOffset(), myVbt);
            this.finalVbtPtrInfoByOffset.put(info.accumOffset(), info);
            OwnerParentage op = new OwnerParentage(info.baseId(), info.parentage());
            this.vbTableIdByOffset.put(info.accumOffset(), op);
            this.vbtOffsetByTableId.put(op, info.accumOffset());
            this.myVbtPtrOffset = this.finalVbtPtrInfoByOffset.firstKey();
            Member newMember = new Member(this, "{vbptr}", (DataType)ClassUtils.VXPTR_TYPE, false, ClassFieldAttributes.UNKNOWN, this.myVbtPtrOffset.intValue());
            this.layoutVbtPtrMembers.add(newMember);
            this.myMembers.add(newMember);
        }
        this.mainVbtPtrOffset = this.finalVbtPtrInfoByOffset.isEmpty() ? null : this.finalVbtPtrInfoByOffset.firstKey();
    }

    private void updateMainVft() {
        for (VirtualFunctionInfo vfInfo : this.virtualFunctionInfo) {
            int tableOffset = vfInfo.tableOffset();
            if (vfInfo.thisAdjuster() != 0 || vfInfo.tableOffset() == -1) continue;
            this.mainVft.addEntry(tableOffset, vfInfo.name(), vfInfo.name(), (Pointer)new PointerDataType((DataType)vfInfo.definition()));
        }
    }

    private VirtualFunctionTable updateVft(VxtManager vxtManager, ClassID baseId, VxtPtrInfo info, VxtPtrInfo parentInfo) {
        List<ClassID> parentParentage;
        ClassID parentId;
        if (!(vxtManager instanceof MsVxtManager)) {
            return null;
        }
        MsVxtManager mvxtManager = (MsVxtManager)vxtManager;
        if (parentInfo == null) {
            parentId = info.baseId();
            List<ClassID> parentage = info.parentage();
            parentParentage = parentage.subList(0, parentage.size() - 1);
        } else {
            parentId = baseId;
            parentParentage = parentInfo.parentage();
        }
        Long finalOffset = info.finalOffset();
        VirtualFunctionTable myVft = (VirtualFunctionTable)this.finalVftByOffset.get(finalOffset);
        if (myVft == null) {
            Integer ordinal = this.getOrdinalOfKey(this.finalVftByOffset, finalOffset);
            myVft = mvxtManager.findVft(this.myId, info.parentage(), ordinal);
            if (myVft == null) {
                return null;
            }
            this.finalVftByOffset.put(finalOffset, myVft);
        }
        myVft.setPtrOffsetInClass(finalOffset);
        VirtualFunctionTable parentVft = mvxtManager.findVft(parentId, parentParentage, null);
        if (parentVft == null) {
            return null;
        }
        for (Map.Entry<Integer, VirtualFunctionTableEntry> mapEntry : parentVft.getEntriesByTableIndex().entrySet()) {
            int tableOffset = mapEntry.getKey();
            VFTableEntry e = mapEntry.getValue();
            SymbolPath parentOrigPath = e.getOriginalPath();
            SymbolPath parentPath = e.getOverridePath();
            VirtualFunctionTableEntry currentEntry = myVft.getEntry(tableOffset);
            if (currentEntry != null) {
                boolean currentOverride;
                SymbolPath currentOrigPath = currentEntry.getOriginalPath();
                SymbolPath currentPath = currentEntry.getOverridePath();
                if (!parentOrigPath.equals((Object)currentOrigPath)) {
                    // empty if block
                }
                boolean parentOverride = !parentOrigPath.equals((Object)parentPath);
                boolean bl = currentOverride = !currentOrigPath.equals((Object)currentPath);
                if (!currentOverride && parentOverride) {
                    myVft.addEntry(tableOffset, parentOrigPath, parentPath, e.getFunctionPointer());
                    continue;
                }
                if (!currentOverride || parentOverride) continue;
                myVft.addEntry(tableOffset, currentOrigPath, currentPath, e.getFunctionPointer());
                continue;
            }
            myVft.addEntry(tableOffset, parentOrigPath, parentPath, e.getFunctionPointer());
        }
        return myVft;
    }

    private void updateVftFromSelf(VirtualFunctionTable vft) {
        for (Map.Entry<Integer, VirtualFunctionTableEntry> mapEntry : vft.getEntriesByTableIndex().entrySet()) {
            int tableOffset = mapEntry.getKey();
            VFTableEntry e = mapEntry.getValue();
            SymbolPath origPath = e.getOriginalPath();
            SymbolPath methodPath = e.getOverridePath();
            String methodName = methodPath.getName();
            Pointer p = e.getFunctionPointer();
            FunctionDefinition tableFunctionDefinition = (FunctionDefinition)p.getDataType();
            for (VirtualFunctionInfo vfInfo : this.virtualFunctionInfo) {
                SymbolPath selfMethodPath = vfInfo.name();
                String selfMethodName = selfMethodPath.getName();
                FunctionDefinition selfFunctionDefinition = vfInfo.definition();
                if (!selfMethodName.equals(methodName) || !selfFunctionDefinition.isEquivalent((DataType)tableFunctionDefinition)) continue;
                methodPath = selfMethodPath;
                break;
            }
            vft.addEntry(tableOffset, origPath, methodPath, e.getFunctionPointer());
        }
    }

    private void updateMainVbt() {
        Integer existingEntries;
        int numEntries = this.virtualLayoutBaseClasses.size();
        if (numEntries < (existingEntries = Integer.valueOf(this.mainVbt.getNumEntries()))) {
            return;
        }
        for (VirtualLayoutBaseClass virtualLayoutBaseClass : this.virtualLayoutBaseClasses) {
            VBTableEntry e;
            int tableOffset = virtualLayoutBaseClass.getOffetFromVbt();
            ClassID baseId = virtualLayoutBaseClass.getBaseClassType().getClassId();
            int vbtPtrOffset = virtualLayoutBaseClass.getBasePointerOffset();
            if ((long)vbtPtrOffset != this.mainVbtPtrOffset || (e = this.mainVbt.getEntry(tableOffset)) != null) continue;
            this.mainVbt.addEntry(tableOffset, baseId);
        }
    }

    private VirtualBaseTable updateVbt(VxtManager vxtManager, ClassID baseId, VxtPtrInfo info, VxtPtrInfo parentInfo) {
        List<ClassID> parentParentage;
        ClassID parentId;
        if (!(vxtManager instanceof MsVxtManager)) {
            return null;
        }
        MsVxtManager mvxtManager = (MsVxtManager)vxtManager;
        if (parentInfo == null) {
            parentId = info.baseId();
            List<ClassID> parentage = info.parentage();
            parentParentage = parentage.subList(0, parentage.size() - 1);
        } else {
            parentId = baseId;
            parentParentage = parentInfo.parentage();
        }
        Long finalOffset = info.finalOffset();
        VirtualBaseTable myVbt = (VirtualBaseTable)this.finalVbtByOffset.get(finalOffset);
        if (myVbt == null) {
            Integer ordinal = this.getOrdinalOfKey(this.finalVbtByOffset, finalOffset);
            myVbt = mvxtManager.findVbt(this.myId, info.parentage(), ordinal);
            if (myVbt == null) {
                return null;
            }
            this.finalVbtByOffset.put(finalOffset, myVbt);
        }
        myVbt.setPtrOffsetInClass(finalOffset);
        VirtualBaseTable parentVbt = mvxtManager.findVbt(parentId, parentParentage, null);
        if (parentVbt == null) {
            return null;
        }
        for (Map.Entry<Integer, VirtualBaseTableEntry> mapEntry : parentVbt.getEntriesByTableIndex().entrySet()) {
            int tableOffset = mapEntry.getKey();
            VBTableEntry e = mapEntry.getValue();
            myVbt.addEntry(tableOffset, e.getClassId());
        }
        return myVbt;
    }

    private Integer getOrdinalOfKey(Map<Long, VXT> map, Long key) {
        int index = 0;
        for (Long offset : this.finalVftByOffset.keySet()) {
            if (offset == key) {
                return index;
            }
            ++index;
        }
        return map.size();
    }

    private VirtualFunctionTable getMainVft(MsVxtManager vxtManager) throws PdbException {
        if (!this.finalVftPtrInfoByOffset.isEmpty()) {
            VxtPtrInfo firstVftPtrInfo = this.finalVftPtrInfoByOffset.firstEntry().getValue();
            VirtualFunctionTable vft = vxtManager.findPrimaryVft(this.myId, firstVftPtrInfo.parentage());
            return vft;
        }
        return null;
    }

    private VirtualBaseTable getMainVbt(MsVxtManager vxtManager) throws PdbException {
        if (!this.finalVbtPtrInfoByOffset.isEmpty()) {
            VxtPtrInfo firstVbtPtrInfo = this.finalVbtPtrInfoByOffset.firstEntry().getValue();
            VirtualBaseTable vbt = vxtManager.findPrimaryVbt(this.myId, firstVbtPtrInfo.parentage());
            if (vbt instanceof ProgramVirtualBaseTable) {
                ProgramVirtualBaseTable pvbt = (ProgramVirtualBaseTable)vbt;
                return pvbt;
            }
            if (vbt instanceof PlaceholderVirtualBaseTable) {
                PlaceholderVirtualBaseTable plvbt = (PlaceholderVirtualBaseTable)vbt;
                ArrayList<VirtualLayoutBaseClass> reorderedVirtualBases = new ArrayList<VirtualLayoutBaseClass>();
                for (ClassID bId : this.depthFirstVirtualBases().keySet()) {
                    for (VirtualLayoutBaseClass base : this.virtualLayoutBaseClasses) {
                        CppCompositeType baseType = base.getBaseClassType();
                        ClassID id = baseType.getClassId();
                        if (!id.equals((Object)bId)) continue;
                        reorderedVirtualBases.add(base);
                    }
                }
                int off = this.selfBaseType.getAlignedLength();
                for (VirtualLayoutBaseClass base : reorderedVirtualBases) {
                    CppCompositeType baseType = base.getBaseClassType();
                    int basePtrOff = base.getBasePointerOffset();
                    Composite baseComposite = baseType.getComposite();
                    off = DataOrganizationImpl.getAlignedOffset((int)baseComposite.getAlignment(), (int)off);
                    this.addPlaceholderVirtualBaseTableEntry(plvbt, vxtManager, base, off - basePtrOff);
                    if (baseType.hasZeroBaseSize) continue;
                    off += baseType.getSelfBaseType().getLength();
                }
                return plvbt;
            }
            if (vbt != null) {
                throw new PdbException("VBT type not expected: " + vbt.getClass().getSimpleName());
            }
        }
        return null;
    }

    private void addPlaceholderVirtualBaseTableEntry(PlaceholderVirtualBaseTable ptable, MsVxtManager vxtManager, VirtualLayoutBaseClass base, long baseOffset) {
        long basePtrOffset = base.getBasePointerOffset();
        if (ptable.getPtrOffsetInClass() != basePtrOffset) {
            return;
        }
        PlaceholderVirtualBaseTableEntry e = ptable.getEntry(base.getOffetFromVbt());
        if (e != null) {
            e.setOffset(baseOffset);
            return;
        }
        ClassID baseId = base.getBaseClassType().getClassId();
        ptable.setBaseClassOffsetAndId(base.getOffetFromVbt(), baseOffset, baseId);
    }

    private LinkedHashMap<ClassID, List<ClassID>> depthFirstVirtualBases() {
        LinkedHashMap<ClassID, List<ClassID>> baseResults;
        CppCompositeType bt;
        if (this.depthFirstVirtualBases != null) {
            return this.depthFirstVirtualBases;
        }
        this.depthFirstVirtualBases = new LinkedHashMap();
        for (DirectLayoutBaseClass directLayoutBaseClass : this.directLayoutBaseClasses) {
            bt = directLayoutBaseClass.getBaseClassType();
            baseResults = bt.depthFirstVirtualBases();
            for (Map.Entry<ClassID, List<ClassID>> entry : baseResults.entrySet()) {
                if (this.depthFirstVirtualBases.containsKey(entry.getKey())) continue;
                this.depthFirstVirtualBases.put(entry.getKey(), entry.getValue());
            }
        }
        for (VirtualLayoutBaseClass virtualLayoutBaseClass : this.virtualLayoutBaseClasses) {
            bt = virtualLayoutBaseClass.getBaseClassType();
            baseResults = bt.depthFirstVirtualBases();
            for (Map.Entry<ClassID, List<ClassID>> entry : baseResults.entrySet()) {
                if (this.depthFirstVirtualBases.containsKey(entry.getKey())) continue;
                this.depthFirstVirtualBases.put(entry.getKey(), entry.getValue());
            }
        }
        for (DirectVirtualLayoutBaseClass directVirtualLayoutBaseClass : this.directVirtualLayoutBaseClasses) {
            bt = directVirtualLayoutBaseClass.getBaseClassType();
            ClassID baseId = bt.getClassId();
            ArrayList<ClassID> baseParentage = new ArrayList<ClassID>(List.of(baseId));
            this.depthFirstVirtualBases.put(baseId, baseParentage);
        }
        for (List list : this.depthFirstVirtualBases.values()) {
            list.addFirst(this.myId);
        }
        return this.depthFirstVirtualBases;
    }

    public void addStaticMember(String memberName, DataType dataType) {
        this.addStaticMember(memberName, dataType, ClassFieldAttributes.UNKNOWN);
    }

    public void addStaticMember(String memberName, DataType dataType, ClassFieldAttributes attributes) {
        this.myMembers.add(new StaticMember(this, memberName, dataType, attributes));
    }

    public int getNumLayoutVirtualBaseClasses() {
        return this.virtualLayoutBaseClasses.size();
    }

    public int getNumSyntacticBaseClasses() {
        return this.syntacticBaseClasses.size();
    }

    public void addSyntacticBaseClass(Composite comp, CppCompositeType baseClassType) throws PdbException {
        this.addSyntacticBaseClass(comp, baseClassType, ClassFieldAttributes.UNKNOWN);
    }

    public void addSyntacticBaseClass(Composite comp, CppCompositeType baseClassType, ClassFieldAttributes attributes) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        this.syntacticBaseClasses.add(new SyntacticBaseClass(this, comp, baseClassType, attributes));
    }

    public void addDirectSyntacticBaseClass(Composite comp, CppCompositeType baseClassType) throws PdbException {
        this.addDirectSyntacticBaseClass(comp, baseClassType, ClassFieldAttributes.UNKNOWN);
    }

    public void addDirectSyntacticBaseClass(Composite comp, CppCompositeType baseClassType, ClassFieldAttributes attributes) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        this.syntacticBaseClasses.add(new DirectSyntacticBaseClass(this, comp, baseClassType, attributes));
    }

    public void addVirtualSyntacticBaseClass(Composite comp, CppCompositeType baseClassType) throws PdbException {
        this.addVirtualSyntacticBaseClass(comp, baseClassType, ClassFieldAttributes.UNKNOWN);
    }

    public void addVirtualSyntacticBaseClass(Composite comp, CppCompositeType baseClassType, ClassFieldAttributes attributes) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        this.syntacticBaseClasses.add(new VirtualSyntacticBaseClass(this, comp, baseClassType, attributes));
    }

    public void insertSyntacticBaseClass(Composite comp, CppCompositeType baseClassType, int ordinal) throws PdbException {
        this.insertSyntacticBaseClass(comp, baseClassType, ClassFieldAttributes.UNKNOWN, ordinal);
    }

    public void insertSyntacticBaseClass(Composite comp, CppCompositeType baseClassType, ClassFieldAttributes attributes, int ordinal) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        if (ordinal < 0 || ordinal > this.getNumSyntacticBaseClasses()) {
            throw new PdbException("Invalid base class insertion index.");
        }
        this.syntacticBaseClasses.add(ordinal, new SyntacticBaseClass(this, comp, baseClassType, attributes));
    }

    public void insertDirectSyntacticBaseClass(Composite comp, CppCompositeType baseClassType, int ordinal) throws PdbException {
        this.insertDirectSyntacticBaseClass(comp, baseClassType, ClassFieldAttributes.UNKNOWN, ordinal);
    }

    public void insertDirectSyntacticBaseClass(Composite comp, CppCompositeType baseClassType, ClassFieldAttributes attributes, int ordinal) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        if (ordinal < 0 || ordinal > this.getNumSyntacticBaseClasses()) {
            throw new PdbException("Invalid base class insertion index.");
        }
        this.syntacticBaseClasses.add(ordinal, new DirectSyntacticBaseClass(this, comp, baseClassType, attributes));
    }

    public void insertVirtualSyntacticBaseClass(Composite comp, CppCompositeType baseClassType, int ordinal) throws PdbException {
        this.insertVirtualSyntacticBaseClass(comp, baseClassType, ClassFieldAttributes.UNKNOWN, ordinal);
    }

    public void insertVirtualSyntacticBaseClass(Composite comp, CppCompositeType baseClassType, ClassFieldAttributes attributes, int ordinal) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        if (ordinal < 0 || ordinal > this.getNumSyntacticBaseClasses()) {
            throw new PdbException("Invalid base class insertion index.");
        }
        this.syntacticBaseClasses.add(ordinal, new VirtualSyntacticBaseClass(this, comp, baseClassType, attributes));
    }

    public void createLayoutFromSyntacticDescription(VxtManager vxtManager, TaskMonitor monitor) {
        for (SyntacticBaseClass base : this.syntacticBaseClasses) {
            if (!(base instanceof DirectSyntacticBaseClass)) continue;
        }
    }

    private class DirectLayoutBaseClass
    extends LayoutBaseClass {
        private int offset;

        private DirectLayoutBaseClass(CppCompositeType cppCompositeType, Composite comp, CppCompositeType baseClassType, ClassFieldAttributes attributes, int offset) {
            super(cppCompositeType, comp, baseClassType, attributes);
            this.offset = offset;
        }

        int getOffset() {
            return this.offset;
        }
    }

    private class DirectVirtualLayoutBaseClass
    extends VirtualLayoutBaseClass {
        private DirectVirtualLayoutBaseClass(CppCompositeType cppCompositeType, Composite comp, CppCompositeType baseClass, ClassFieldAttributes attributes, int basePointerOffset, DataType vbptr, int offsetFromVbt) {
            super(cppCompositeType, comp, baseClass, attributes, basePointerOffset, vbptr, offsetFromVbt);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(super.toString());
            if (builder.length() > 0) {
                builder.append(">");
                builder.insert(0, "<");
            }
            return builder.toString();
        }
    }

    private class IndirectVirtualLayoutBaseClass
    extends VirtualLayoutBaseClass {
        private IndirectVirtualLayoutBaseClass(CppCompositeType cppCompositeType, Composite comp, CppCompositeType baseClass, ClassFieldAttributes attributes, int basePointerOffset, DataType vbptr, int offsetFromVbt) {
            super(cppCompositeType, comp, baseClass, attributes, basePointerOffset, vbptr, offsetFromVbt);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(super.toString());
            if (builder.length() > 0) {
                builder.append(">");
                builder.insert(0, "<indirect ");
            }
            return builder.toString();
        }
    }

    private class Member
    extends AbstractMember {
        private int offset;

        private Member(CppCompositeType cppCompositeType, String name, DataType dataType, boolean isFlexibleArray, ClassFieldAttributes attributes, int offset) {
            this(cppCompositeType, name, dataType, isFlexibleArray, attributes, offset, null);
        }

        private Member(CppCompositeType cppCompositeType, String name, DataType dataType, boolean isFlexibleArray, ClassFieldAttributes attributes, int offset, String comment) {
            super(cppCompositeType, name, dataType, isFlexibleArray, attributes, comment);
            this.offset = offset;
        }

        int getOffset() {
            return this.offset;
        }
    }

    private record VirtualFunctionInfo(Integer tableOffset, Integer thisAdjuster, SymbolPath name, FunctionDefinition definition) {
    }

    private abstract class BaseClass {
        private Composite comp;
        private CppCompositeType baseClassType;
        private ClassFieldAttributes attributes;

        private BaseClass(CppCompositeType cppCompositeType, Composite comp, CppCompositeType baseClassType, ClassFieldAttributes attributes) {
            this.comp = comp;
            this.baseClassType = baseClassType;
            this.attributes = attributes;
        }

        Composite getBaseClassComposite() {
            return this.comp;
        }

        CppCompositeType getBaseClassType() {
            return this.baseClassType;
        }

        ClassFieldAttributes getAttributes() {
            return this.attributes;
        }

        DataTypePath getDataTypePath() {
            return this.baseClassType.getDataTypePath();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.attributes);
            builder.append(this.baseClassType.getName());
            return builder.toString();
        }

        Composite getSelfBaseDataType() {
            CppCompositeType cct = this.getBaseClassType();
            return ClassUtils.getSelfBaseType((Composite)this.comp);
        }
    }

    private static class CppClassType
    extends CppCompositeType {
        private CppClassType(CategoryPath baseCategoryPath, SymbolPath symbolPath, Composite composite, String mangledName) {
            super(baseCategoryPath, symbolPath, composite, mangledName);
            this.setClass();
        }
    }

    private static class CppStructType
    extends CppCompositeType {
        private CppStructType(CategoryPath baseCategoryPath, SymbolPath symbolPath, Composite composite, String mangledName) {
            super(composite.getCategoryPath(), symbolPath, composite, mangledName);
            this.setStruct();
        }
    }

    private static class PNode {
        private String name;
        private List<PNode> branches;
        private int pathCount;

        private PNode(String name) {
            this.name = name;
            this.branches = new ArrayList<PNode>();
            this.pathCount = 0;
        }

        private void incrementPathCount() {
            ++this.pathCount;
        }

        private int getPathCount() {
            return this.pathCount;
        }

        private PNode getBranch(String branchName) {
            for (PNode node : this.branches) {
                if (!node.name.equals(branchName)) continue;
                return node;
            }
            return null;
        }

        private PNode getOrAddBranch(String branchName) {
            PNode node = this.getBranch(branchName);
            if (node != null) {
                return node;
            }
            node = new PNode(branchName);
            this.branches.add(node);
            return node;
        }
    }

    private record VxtPtrInfo(Long finalOffset, Long accumOffset, ClassID baseId, List<ClassID> parentage) implements Comparable<VxtPtrInfo>
    {
        @Override
        public int compareTo(VxtPtrInfo other) {
            int val = Long.compare(this.finalOffset, other.finalOffset);
            if (val != 0) {
                return val;
            }
            val = Long.compare(this.accumOffset, other.accumOffset);
            if (val != 0) {
                return val;
            }
            val = this.baseId.compareTo(other.baseId);
            if (val != 0) {
                return val;
            }
            int sizeComp = this.parentage.size() - other.parentage.size();
            Iterator<ClassID> iter = this.parentage.iterator();
            Iterator<ClassID> oiter = other.parentage.iterator();
            while (iter.hasNext() && oiter.hasNext()) {
                ClassID oid;
                ClassID id = iter.next();
                val = id.compareTo(oid = oiter.next());
                if (val == 0) continue;
                return val;
            }
            return sizeComp;
        }
    }

    private static class ClassPdbMember
    extends PdbMember {
        private DataType dataType;
        private boolean isFlexibleArray;

        ClassPdbMember(String name, DataType dataType, boolean isFlexibleArray, int offset, String comment) {
            super(name, dataType.getName(), offset, comment);
            this.dataType = dataType;
            this.isFlexibleArray = isFlexibleArray;
        }

        @Override
        public String getDataTypeName() {
            return this.dataType.getName();
        }

        @Override
        protected WrappedDataType getDataType() throws CancelledException {
            return new WrappedDataType(this.dataType, this.isFlexibleArray, false);
        }
    }

    private abstract class VirtualLayoutBaseClass
    extends LayoutBaseClass {
        private int basePointerOffset;
        private DataType vbptr;
        private int offsetFromVbt;

        private VirtualLayoutBaseClass(CppCompositeType cppCompositeType, Composite comp, CppCompositeType baseClass, ClassFieldAttributes attributes, int basePointerOffset, DataType vbptr, int offsetFromVbt) {
            super(cppCompositeType, comp, baseClass, attributes);
            this.basePointerOffset = basePointerOffset;
            this.vbptr = vbptr;
            this.offsetFromVbt = offsetFromVbt;
        }

        DataType getVbptr() {
            return this.vbptr;
        }

        int getOffetFromVbt() {
            return this.offsetFromVbt;
        }

        int getBasePointerOffset() {
            return this.basePointerOffset;
        }
    }

    private class StaticMember
    extends AbstractMember {
        private StaticMember(CppCompositeType cppCompositeType, String name, DataType dataType, ClassFieldAttributes attributes) {
            super(cppCompositeType, name, dataType, false, attributes);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(super.toString());
            if (builder.length() > 0) {
                builder.insert(0, "static ");
            }
            return builder.toString();
        }
    }

    private class SyntacticBaseClass
    extends BaseClass {
        private SyntacticBaseClass(CppCompositeType cppCompositeType, Composite comp, CppCompositeType baseClassType, ClassFieldAttributes attributes) {
            super(cppCompositeType, comp, baseClassType, attributes);
        }
    }

    private class DirectSyntacticBaseClass
    extends SyntacticBaseClass {
        private DirectSyntacticBaseClass(CppCompositeType cppCompositeType, Composite comp, CppCompositeType baseClassType, ClassFieldAttributes attributes) {
            super(cppCompositeType, comp, baseClassType, attributes);
        }
    }

    private class VirtualSyntacticBaseClass
    extends SyntacticBaseClass {
        private VirtualSyntacticBaseClass(CppCompositeType cppCompositeType, Composite comp, CppCompositeType baseClassType, ClassFieldAttributes attributes) {
            super(cppCompositeType, comp, baseClassType, attributes);
        }
    }

    private abstract class AbstractMember {
        private String memberName;
        private DataType dataType;
        private boolean isFlexibleArray;
        private ClassFieldAttributes attributes;
        private String comment;

        private AbstractMember(CppCompositeType cppCompositeType, String name, DataType dataType, boolean isFlexibleArray, ClassFieldAttributes attributes) {
            this(cppCompositeType, name, dataType, isFlexibleArray, attributes, null);
        }

        private AbstractMember(CppCompositeType cppCompositeType, String name, DataType dataType, boolean isFlexibleArray, ClassFieldAttributes attributes, String comment) {
            this.memberName = name;
            this.dataType = dataType;
            this.isFlexibleArray = isFlexibleArray;
            this.attributes = attributes;
            this.comment = comment;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.dataType);
            if (builder.length() > 0 && this.memberName.length() > 0) {
                builder.append(' ');
            }
            builder.append(this.memberName);
            return builder.toString();
        }

        String getName() {
            return this.memberName;
        }

        DataType getDataType() {
            return this.dataType;
        }

        boolean isFlexibleArray() {
            return this.isFlexibleArray;
        }

        ClassFieldAttributes getAttributes() {
            return this.attributes;
        }

        void setComment(String comment) {
            this.comment = comment;
        }

        String getComment() {
            return this.comment;
        }
    }

    private abstract class LayoutBaseClass
    extends BaseClass {
        Structure layout = null;

        LayoutBaseClass(CppCompositeType cppCompositeType, Composite comp, CppCompositeType baseClassType, ClassFieldAttributes attributes) {
            super(cppCompositeType, comp, baseClassType, attributes);
        }

        void setLayout(Structure layout) {
            this.layout = layout;
        }

        Structure getLayout() {
            if (this.layout == null) {
                // empty if block
            }
            return this.layout;
        }
    }
}

