/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractArrayMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsDataTypeApplier;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;

public class ArrayTypeApplier
extends MsDataTypeApplier {
    public ArrayTypeApplier(DefaultPdbApplicator applicator) {
        super(applicator);
    }

    @Override
    boolean apply(AbstractMsType type) throws PdbException, CancelledException {
        AbstractArrayMsType arrayType = (AbstractArrayMsType)type;
        RecordNumber underlyingRecordNumber = arrayType.getElementTypeRecordNumber();
        DataType underlyingDataType = this.applicator.getDataTypeOrSchedule(underlyingRecordNumber);
        if (underlyingDataType == null) {
            return false;
        }
        int numElements = this.calculateNumElements(arrayType, underlyingDataType);
        if (numElements == -1) {
            underlyingDataType = Undefined1DataType.dataType;
            numElements = this.getSizeInt(arrayType);
        }
        ArrayDataType dataType = new ArrayDataType(underlyingDataType, numElements, -1, this.applicator.getDataTypeManager());
        this.applicator.putDataType(arrayType, (DataType)dataType);
        return true;
    }

    boolean isFlexibleArray(AbstractMsType type) {
        return BigInteger.ZERO.equals(type.getSize());
    }

    private int calculateNumElements(AbstractArrayMsType type, DataType underlyingDataType) {
        long longUnderlyingSize;
        if (underlyingDataType == null) {
            underlyingDataType = Undefined1DataType.dataType;
            String msg = "PDB Type index " + type.getRecordNumber().getNumber() + ":\n   Null underlying data type for " + type.getClass().getSimpleName() + ":\n      " + type.getName() + "\n   Using " + String.valueOf(underlyingDataType);
            Msg.warn((Object)this, (Object)msg);
        }
        if ((longUnderlyingSize = (long)underlyingDataType.getLength()) > Integer.MAX_VALUE) {
            String msg = "PDB " + type.getClass().getSimpleName() + ": Underlying type too large " + underlyingDataType.getName();
            Msg.warn((Object)this, (Object)msg);
            underlyingDataType = Undefined1DataType.dataType;
            longUnderlyingSize = 1L;
        } else if (longUnderlyingSize == 0L) {
            longUnderlyingSize = 1L;
        }
        long longArraySize = this.getSizeLong(type);
        long longNumElements = longArraySize / longUnderlyingSize;
        if (longNumElements > Integer.MAX_VALUE) {
            String msg = "PDB " + type.getClass().getSimpleName() + ": Array num elements too large: " + longUnderlyingSize;
            Msg.warn((Object)this, (Object)msg);
            longNumElements = 1L;
        } else if (longArraySize == 0L) {
            longNumElements = 0L;
        } else if (longArraySize % longUnderlyingSize != 0L) {
            String msg = "PDB " + type.getClass().getSimpleName() + ": Array num elements calculation error underlying type " + longArraySize + " % " + longUnderlyingSize;
            Msg.warn((Object)this, (Object)msg);
            return -1;
        }
        int numElements = (int)longNumElements;
        return numElements;
    }
}

