/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import ghidra.app.decompiler.ClangSyntaxToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.util.HelpLocation;

public class GoToPreviousBraceAction
extends AbstractDecompilerAction {
    public GoToPreviousBraceAction() {
        super("Go To Previous Brace");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "GoToBrace"));
        this.setKeyBindingData(new KeyBindingData(91, 64));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        return true;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        ClangToken token = context.getTokenAtCursor();
        ClangSyntaxToken brace = DecompilerUtils.getNextBrace(token, false);
        if (brace != null) {
            DecompilerPanel panel = context.getDecompilerPanel();
            panel.goToToken(brace);
        }
    }
}

