/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.debug;

import docking.widgets.label.GDLabel;
import generic.theme.Gui;
import ghidra.feature.fid.db.FidQueryService;
import ghidra.feature.fid.db.FunctionRecord;
import ghidra.feature.fid.db.LibraryRecord;
import ghidra.feature.fid.debug.FidDebugUtils;
import ghidra.feature.fid.service.FidService;
import ghidra.program.model.lang.LanguageID;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class FidFunctionDebugPanel
extends JPanel {
    private final FidService service;
    private final FidQueryService fidQueryService;
    private final FunctionRecord functionRecord;
    private static final int MAGIC_MAXIMUM_LENGTH = 30;

    public FidFunctionDebugPanel(FidService service, FidQueryService fidQueryService, FunctionRecord functionRecord) {
        this.service = service;
        this.fidQueryService = fidQueryService;
        this.functionRecord = functionRecord;
        this.initialize();
    }

    private void addButton(String text, ActionListener listener) {
        JButton button = new JButton(text);
        button.addActionListener(listener);
        button.setHorizontalAlignment(2);
        Gui.registerFont((Component)button, (String)"font.monospaced");
        this.add(button);
    }

    private void addLabel(String text) {
        GDLabel label = new GDLabel(text);
        label.setHorizontalAlignment(2);
        Gui.registerFont((Component)label, (String)"font.monospaced");
        this.add((Component)label);
    }

    private void initialize() {
        this.setLayout(new GridLayout(0, 1));
        LibraryRecord libraryRecord = this.fidQueryService.getLibraryForFunction(this.functionRecord);
        LanguageID languageID = libraryRecord.getGhidraLanguageID();
        this.addLabel(String.format("%s %s %s (%s)", libraryRecord.getLibraryFamilyName(), libraryRecord.getLibraryVersion(), libraryRecord.getLibraryVariant(), languageID.getIdAsString()));
        this.addButton(String.format("0x%016x", this.functionRecord.getID()), e -> FidDebugUtils.searchByFunctionID(this.functionRecord.getID(), this.service, this.fidQueryService));
        this.addButton(this.functionRecord.getName(), e -> FidDebugUtils.searchByName(this.functionRecord.getName(), this.service, this.fidQueryService));
        this.addButton(FidFunctionDebugPanel.shorten(this.functionRecord.getDomainPath()), e -> FidDebugUtils.searchByDomainPath(this.functionRecord.getDomainPath(), this.service, this.fidQueryService));
        this.addLabel(String.format("Entry Point: 0x%x", this.functionRecord.getEntryPoint()));
        this.addButton(String.format("FH: 0x%016x (%d)", this.functionRecord.getFullHash(), this.functionRecord.getCodeUnitSize()), e -> FidDebugUtils.searchByFullHash(this.functionRecord.getFullHash(), this.service, this.fidQueryService));
        this.addButton(String.format("XH: 0x%016x (+%d)", this.functionRecord.getSpecificHash(), this.functionRecord.getSpecificHashAdditionalSize()), e -> FidDebugUtils.searchBySpecificHash(this.functionRecord.getSpecificHash(), this.service, this.fidQueryService));
        this.addLabel(String.format("%s %s %s %s %s", this.functionRecord.hasTerminator() ? "" : "(unterminated function)", this.functionRecord.autoFail() ? "(auto-fail)" : "", this.functionRecord.autoPass() ? "(auto-pass)" : "", this.functionRecord.isForceSpecific() ? "(force-specific)" : "", this.functionRecord.isForceRelation() ? "(force-relation)" : ""));
    }

    private static String shorten(String domainPath) {
        Object result;
        String[] splits = domainPath.split("/");
        StringBuilder sb = new StringBuilder();
        for (int ii = splits.length - 1; ii >= 0; --ii) {
            sb.insert(0, splits[ii]);
            if (ii != 0) {
                sb.insert(0, "/");
            }
            if (sb.length() >= 30) break;
        }
        if (((String)(result = sb.toString())).length() < domainPath.length()) {
            result = "..." + (String)result;
        }
        return result;
    }
}

