/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.CpuTimer;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.ThreadCpu;
import org.hyperic.sigar.test.SigarTestCase;

public class TestThreadCpu
extends SigarTestCase {
    public TestThreadCpu(String name) {
        super(name);
    }

    public void testCreate() throws Exception {
        ThreadCpu cpu;
        Sigar sigar = this.getSigar();
        try {
            cpu = sigar.getThreadCpu();
        }
        catch (SigarNotImplementedException e) {
            return;
        }
        this.assertGtEqZeroTrace("User", cpu.getUser());
        this.assertGtEqZeroTrace("Sys", cpu.getSys());
        this.assertGtEqZeroTrace("Total", cpu.getTotal());
        CpuTimer timer = new CpuTimer(sigar);
        timer.start();
        for (int i = 0; i < 1000000; ++i) {
            System.getProperty("java.home");
        }
        String sleepTime = System.getProperty("sigar.testThreadCpu.sleep");
        if (sleepTime != null) {
            Thread.sleep(Integer.parseInt(sleepTime) * 1000);
        }
        timer.stop();
        this.traceln("\nUsage...\n");
        this.assertGtEqZeroTrace("User", timer.getCpuUser());
        this.assertGtEqZeroTrace("Sys", timer.getCpuSys());
        this.assertGtEqZeroTrace("Total", timer.getCpuTotal());
        this.assertGtEqZeroTrace("Real Time", timer.getTotalTime());
        this.traceln("Cpu Percent=" + CpuPerc.format(timer.getCpuUsage()));
    }
}

