/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcodeInject;

import ghidra.app.util.pcodeInject.ArrayMethods;
import ghidra.app.util.pcodeInject.JavaInvocationType;
import ghidra.javaclass.format.ClassFileAnalysisState;
import ghidra.javaclass.format.ClassFileJava;
import ghidra.javaclass.format.DescriptorDecoder;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolReferenceInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolClassInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolDoubleInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolFieldReferenceInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolFloatInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolIntegerInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolInterfaceMethodReferenceInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolInvokeDynamicInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolLongInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolMethodHandleInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolMethodReferenceInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolMethodTypeInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolNameAndTypeInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolStringInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolUtf8Info;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.LongDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.ConstantPool;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.List;

public class ConstantPoolJava
extends ConstantPool {
    public static final String CPOOL_OP = "cpool";
    private ClassFileJava classFile;
    private AbstractConstantPoolInfoJava[] constantPool;
    private DataTypeManager dtManager = null;
    public static final String CPOOL_ANEWARRAY = "0";
    public static final String CPOOL_CHECKCAST = "1";
    public static final String CPOOL_GETFIELD = "2";
    public static final String CPOOL_GETSTATIC = "3";
    public static final String CPOOL_LDC = "4";
    public static final String CPOOL_LDC2_W = "5";
    public static final String CPOOL_INSTANCEOF = "6";
    public static final String CPOOL_INVOKEDYNAMIC = "7";
    public static final String CPOOL_INVOKEINTERFACE = "8";
    public static final String CPOOL_INVOKESPECIAL = "9";
    public static final String CPOOL_INVOKESTATIC = "10";
    public static final String CPOOL_INVOKEVIRTUAL = "11";
    public static final String CPOOL_MULTIANEWARRAY = "12";
    public static final String CPOOL_NEW = "13";
    public static final String CPOOL_NEWARRAY = "14";
    public static final String CPOOL_PUTSTATIC = "15";
    public static final String CPOOL_PUTFIELD = "16";
    public static final String CPOOL_ARRAYLENGTH = "17";

    public ConstantPoolJava(Program program) throws IOException {
        ClassFileAnalysisState analysisState = ClassFileAnalysisState.getState(program);
        this.classFile = analysisState.getClassFile();
        this.constantPool = this.classFile.getConstantPool();
        this.dtManager = program.getDataTypeManager();
    }

    private void fillinMethod(int index, int name_and_type_index, ConstantPool.Record res, JavaInvocationType methodType) {
        ParameterDefinitionImpl thisParam;
        ParameterDefinitionImpl[] paramDefs;
        ConstantPoolNameAndTypeInfo methodNameAndType = (ConstantPoolNameAndTypeInfo)this.constantPool[name_and_type_index];
        int name_index = methodNameAndType.getNameIndex();
        res.tag = 3;
        if (methodType.equals((Object)JavaInvocationType.INVOKE_STATIC)) {
            AbstractConstantPoolReferenceInfo poolRef = (AbstractConstantPoolReferenceInfo)this.constantPool[index];
            ConstantPoolClassInfo classInfo = (ConstantPoolClassInfo)this.constantPool[poolRef.getClassIndex()];
            int classNameIndex = classInfo.getNameIndex();
            String fullyQualifiedName = ((ConstantPoolUtf8Info)this.constantPool[classNameIndex]).getString();
            String className = this.getClassName(fullyQualifiedName);
            res.token = className + "." + ((ConstantPoolUtf8Info)this.constantPool[name_index]).getString();
        } else {
            res.token = ((ConstantPoolUtf8Info)this.constantPool[name_index]).getString();
        }
        int descriptor_index = methodNameAndType.getDescriptorIndex();
        ConstantPoolUtf8Info descriptorInfo = (ConstantPoolUtf8Info)this.constantPool[descriptor_index];
        String descriptor = descriptorInfo.getString();
        String uniqueifier = Integer.toHexString(index);
        FunctionDefinitionDataType funcDef = new FunctionDefinitionDataType(uniqueifier + "_" + res.token);
        DataType returnType = DescriptorDecoder.getReturnTypeOfMethodDescriptor(descriptor, this.dtManager);
        funcDef.setReturnType(returnType);
        List<DataType> params = DescriptorDecoder.getDataTypeList(descriptor, this.dtManager);
        if (methodType.equals((Object)JavaInvocationType.INVOKE_STATIC) || methodType.equals((Object)JavaInvocationType.INVOKE_DYNAMIC)) {
            paramDefs = new ParameterDefinitionImpl[params.size()];
            int max = params.size();
            for (int i = 0; i < max; ++i) {
                ParameterDefinitionImpl currentParam;
                paramDefs[i] = currentParam = new ParameterDefinitionImpl("", params.get(i), null);
            }
            try {
                funcDef.setCallingConvention("__stdcall");
            }
            catch (InvalidInputException e) {
                throw new AssertException((Throwable)e);
            }
        }
        paramDefs = new ParameterDefinitionImpl[params.size() + 1];
        paramDefs[0] = thisParam = new ParameterDefinitionImpl("objectRef", (DataType)new Pointer32DataType((DataType)VoidDataType.dataType), null);
        int max = params.size();
        for (int i = 1; i <= max; ++i) {
            ParameterDefinitionImpl currentParam;
            paramDefs[i] = currentParam = new ParameterDefinitionImpl("", params.get(i - 1), null);
        }
        try {
            funcDef.setCallingConvention("__thiscall");
        }
        catch (InvalidInputException e) {
            throw new AssertException((Throwable)e);
        }
        funcDef.setArguments((ParameterDefinition[])paramDefs);
        res.type = new PointerDataType((DataType)funcDef);
    }

    public ConstantPool.Record getRecord(long[] ref) {
        ConstantPool.Record res = new ConstantPool.Record();
        String op = Long.toString(ref[1]);
        if (op.equals(CPOOL_NEWARRAY)) {
            res.tag = 3;
            res.token = ArrayMethods.getPrimitiveArrayToken((int)ref[0]);
            DataType elementType = ArrayMethods.getArrayBaseType((int)ref[0], this.dtManager);
            res.type = this.dtManager.getPointer(elementType);
            return res;
        }
        if (op.equals(CPOOL_ARRAYLENGTH)) {
            res.tag = 5;
            res.token = "length";
            res.type = IntegerDataType.dataType;
            return res;
        }
        AbstractConstantPoolInfoJava poolRef = this.constantPool[(int)ref[0]];
        switch (op) {
            case "0": 
            case "13": {
                res.tag = 2;
                int name_index = ((ConstantPoolClassInfo)poolRef).getNameIndex();
                String fullyQualifiedName = ((ConstantPoolUtf8Info)this.constantPool[name_index]).getString();
                String[] parts = fullyQualifiedName.split("/");
                res.token = parts[parts.length - 1];
                StringBuilder sb = new StringBuilder();
                for (String part : parts) {
                    sb.append('/');
                    sb.append(part);
                }
                DataTypePath dataPath = new DataTypePath(sb.toString(), res.token);
                res.type = new PointerDataType(this.dtManager.getDataType(dataPath));
                break;
            }
            case "1": {
                this.setTypeNameInfo(poolRef, res);
                res.tag = 7;
                PointerDataType pointerType = (PointerDataType)res.type;
                String typeName = pointerType.getDataType().getDisplayName();
                res.token = "checkcast(" + typeName + ")";
                break;
            }
            case "6": {
                res.tag = 6;
                res.token = "instanceof";
                this.setTypeNameInfo(poolRef, res);
                break;
            }
            case "2": 
            case "16": 
            case "3": 
            case "15": {
                this.handlePutAndGetOps(poolRef, res, op);
                break;
            }
            case "7": {
                int name_and_type_index = ((ConstantPoolInvokeDynamicInfo)poolRef).getNameAndTypeIndex();
                this.fillinMethod((int)ref[0], name_and_type_index, res, JavaInvocationType.INVOKE_DYNAMIC);
                break;
            }
            case "8": {
                int name_and_type_index = ((ConstantPoolInterfaceMethodReferenceInfo)poolRef).getNameAndTypeIndex();
                this.fillinMethod((int)ref[0], name_and_type_index, res, JavaInvocationType.INVOKE_INTERFACE);
                break;
            }
            case "9": {
                AbstractConstantPoolReferenceInfo refInfo = (AbstractConstantPoolReferenceInfo)poolRef;
                int name_and_type_index = refInfo.getNameAndTypeIndex();
                this.fillinMethod((int)ref[0], name_and_type_index, res, JavaInvocationType.INVOKE_SPECIAL);
                break;
            }
            case "10": {
                AbstractConstantPoolReferenceInfo refInfo = (AbstractConstantPoolReferenceInfo)poolRef;
                int name_and_type_index = refInfo.getNameAndTypeIndex();
                this.fillinMethod((int)ref[0], name_and_type_index, res, JavaInvocationType.INVOKE_STATIC);
                break;
            }
            case "11": {
                int name_and_type_index = ((ConstantPoolMethodReferenceInfo)poolRef).getNameAndTypeIndex();
                this.fillinMethod((int)ref[0], name_and_type_index, res, JavaInvocationType.INVOKE_VIRTUAL);
                break;
            }
            case "4": {
                if (poolRef instanceof ConstantPoolIntegerInfo) {
                    res.tag = 0;
                    res.token = "int";
                    res.value = ((ConstantPoolIntegerInfo)poolRef).getValue();
                    res.type = IntegerDataType.dataType;
                    break;
                }
                if (poolRef instanceof ConstantPoolFloatInfo) {
                    res.tag = 0;
                    res.token = "float";
                    res.value = (long)((ConstantPoolFloatInfo)poolRef).getRawBytes() & 0xFFFFFFFFL;
                    res.type = FloatDataType.dataType;
                    break;
                }
                if (poolRef instanceof ConstantPoolStringInfo) {
                    int string_index = ((ConstantPoolStringInfo)poolRef).getStringIndex();
                    res.tag = 1;
                    res.byteData = ((ConstantPoolUtf8Info)this.constantPool[string_index]).getBytes();
                    res.type = DescriptorDecoder.getReferenceTypeOfDescriptor("java/lang/String", this.dtManager, false);
                    break;
                }
                if (poolRef instanceof ConstantPoolClassInfo) {
                    res.tag = 2;
                    int name_index = ((ConstantPoolClassInfo)poolRef).getNameIndex();
                    String fullyQualifiedName = ((ConstantPoolUtf8Info)this.constantPool[name_index]).getString();
                    String className = this.getClassName(fullyQualifiedName);
                    res.token = className + ".class";
                    res.type = DescriptorDecoder.getReferenceTypeOfDescriptor(fullyQualifiedName, this.dtManager, false);
                    break;
                }
                if (poolRef instanceof ConstantPoolMethodTypeInfo) {
                    res.tag = 3;
                    int name_index = ((ConstantPoolMethodTypeInfo)poolRef).getDescriptorIndex();
                    res.token = ((ConstantPoolUtf8Info)this.constantPool[name_index]).getString();
                    res.type = this.dtManager.getPointer((DataType)DWordDataType.dataType);
                    break;
                }
                if (!(poolRef instanceof ConstantPoolMethodHandleInfo)) break;
                res.tag = 3;
                res.type = this.dtManager.getPointer((DataType)DWordDataType.dataType);
                break;
            }
            case "5": {
                if (poolRef instanceof ConstantPoolLongInfo) {
                    res.tag = 0;
                    res.token = "long";
                    res.value = ((ConstantPoolLongInfo)poolRef).getValue();
                    res.type = LongDataType.dataType;
                    break;
                }
                res.tag = 0;
                res.token = "double";
                res.value = ((ConstantPoolDoubleInfo)poolRef).getRawBytes();
                res.type = DoubleDataType.dataType;
                break;
            }
            case "12": {
                res.tag = 2;
                res.type = new PointerDataType((DataType)VoidDataType.dataType);
                int nameIndex = ((ConstantPoolClassInfo)poolRef).getNameIndex();
                ConstantPoolUtf8Info utf8Info = (ConstantPoolUtf8Info)this.constantPool[nameIndex];
                String classNameWithSemicolon = utf8Info.getString();
                res.token = DescriptorDecoder.getTypeNameFromDescriptor(classNameWithSemicolon, false, false);
            }
        }
        return res;
    }

    private void handlePutAndGetOps(AbstractConstantPoolInfoJava poolRef, ConstantPool.Record res, String op) {
        int name_and_type_index = ((ConstantPoolFieldReferenceInfo)poolRef).getNameAndTypeIndex();
        ConstantPoolNameAndTypeInfo fieldNameAndType = (ConstantPoolNameAndTypeInfo)this.constantPool[name_and_type_index];
        int name_index = fieldNameAndType.getNameIndex();
        switch (op) {
            case "2": 
            case "16": {
                res.token = ((ConstantPoolUtf8Info)this.constantPool[name_index]).getString();
                break;
            }
            case "3": 
            case "15": {
                int class_index = ((ConstantPoolFieldReferenceInfo)poolRef).getClassIndex();
                ConstantPoolClassInfo classInfo = (ConstantPoolClassInfo)this.constantPool[class_index];
                int classNameIndex = classInfo.getNameIndex();
                String fullyQualifiedName = ((ConstantPoolUtf8Info)this.constantPool[classNameIndex]).getString();
                String className = this.getClassName(fullyQualifiedName);
                res.token = className + "." + ((ConstantPoolUtf8Info)this.constantPool[name_index]).getString();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid op: " + op);
            }
        }
        res.tag = 4;
        int descriptor_index = fieldNameAndType.getDescriptorIndex();
        ConstantPoolUtf8Info descriptorInfo = (ConstantPoolUtf8Info)this.constantPool[descriptor_index];
        String descriptor = descriptorInfo.getString();
        DataType type = DescriptorDecoder.getDataTypeOfDescriptor(descriptor, this.dtManager);
        res.type = new PointerDataType(type);
    }

    private void setTypeNameInfo(AbstractConstantPoolInfoJava poolRef, ConstantPool.Record res) {
        int name_index = ((ConstantPoolClassInfo)poolRef).getNameIndex();
        String fullyQualifiedName = ((ConstantPoolUtf8Info)this.constantPool[name_index]).getString();
        String[] parts = null;
        StringBuilder sb = null;
        if (fullyQualifiedName.startsWith("[")) {
            parts = fullyQualifiedName.split("/");
            sb = new StringBuilder();
            for (String part : parts) {
                sb.append('/');
                sb.append(part);
            }
        } else {
            parts = fullyQualifiedName.split("/");
            sb = new StringBuilder();
            for (String part : parts) {
                sb.append('/');
                sb.append(part);
            }
        }
        DataTypePath dataPath = new DataTypePath(sb.toString(), parts[parts.length - 1]);
        res.type = new PointerDataType(this.dtManager.getDataType(dataPath));
    }

    private String getClassName(String fullyQualifiedName) {
        int lastSlash = fullyQualifiedName.lastIndexOf("/");
        return fullyQualifiedName.substring(lastSlash + 1, fullyQualifiedName.length());
    }

    public AbstractConstantPoolInfoJava[] getConstantPool() {
        return this.constantPool;
    }
}

