/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.PairInput;
import ghidra.features.bsim.query.protocol.ResponsePair;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class QueryPair
extends BSimQuery<ResponsePair> {
    public List<PairInput> pairs = new ArrayList<PairInput>();
    public ResponsePair pairResponse;

    public QueryPair() {
        super("querypair");
    }

    @Override
    public void buildResponseTemplate() {
        if (this.response == null) {
            this.pairResponse = new ResponsePair();
            this.response = this.pairResponse;
        }
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        for (PairInput pairInput : this.pairs) {
            pairInput.saveXml(fwrite);
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        XmlElement note;
        XmlElement startEl = parser.start(new String[]{this.name});
        while ((note = parser.peek()).isStart()) {
            PairInput pairInput = new PairInput();
            pairInput.restoreXml(parser);
            this.pairs.add(pairInput);
        }
        parser.end(startEl);
    }
}

