/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.description;

import generic.lsh.vector.LSHVector;
import generic.lsh.vector.LSHVectorFactory;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;

public class VectorResult {
    public long vectorid;
    public double sim;
    public double signif;
    public int hitcount;
    public LSHVector vec;

    public VectorResult() {
        this.vectorid = 0L;
        this.hitcount = 0;
        this.vec = null;
    }

    public VectorResult(long vid, int cnt, double sm, double sg, LSHVector v) {
        this.vectorid = vid;
        this.sim = sm;
        this.signif = sg;
        this.hitcount = cnt;
        this.vec = v;
    }

    public void saveXml(Writer write) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append("<vec");
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"id", (long)this.vectorid);
        buf.append(">\n");
        buf.append(" <hit>").append(this.hitcount).append("</hit>\n");
        buf.append(" <sim>").append(Double.toString(this.sim)).append("</sim>\n");
        buf.append(" <sig>").append(Double.toString(this.signif)).append("</sig>\n");
        write.append(buf.toString());
        if (this.vec != null) {
            this.vec.saveXml(write);
        }
        write.append("</vec>\n");
    }

    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) {
        XmlElement el = parser.start(new String[]{"vec"});
        this.vectorid = SpecXmlUtils.decodeLong((String)el.getAttribute("id"));
        parser.start(new String[]{"hit"});
        this.hitcount = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"sim"});
        this.sim = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"sig"});
        this.signif = Double.parseDouble(parser.end().getText());
        if (parser.peek().isStart()) {
            this.vec = vectorFactory.restoreVectorFromXml(parser);
        }
        parser.end();
    }

    public int hashCode() {
        return Objects.hash(this.hitcount, this.signif, this.sim, this.vec, this.vectorid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VectorResult other = (VectorResult)obj;
        return this.hitcount == other.hitcount && Double.doubleToLongBits(this.signif) == Double.doubleToLongBits(other.signif) && Double.doubleToLongBits(this.sim) == Double.doubleToLongBits(other.sim) && Objects.equals(this.vec, other.vec) && this.vectorid == other.vectorid;
    }
}

