/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.dialog;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.FunctionDatabase;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.features.bsim.query.facade.QueryDatabaseException;

public class BSimServerCache {
    private BSimServerInfo serverInfo;
    private DatabaseInformation databaseInfo;
    private LSHVectorFactory lshVectorFactory;

    public BSimServerCache(BSimServerInfo severInfo) throws QueryDatabaseException {
        this.serverInfo = severInfo;
        this.initialize();
    }

    public BSimServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public DatabaseInformation getDatabaseInformation() {
        return this.databaseInfo;
    }

    public LSHVectorFactory getLSHVectorFactory() {
        return this.lshVectorFactory;
    }

    private void initialize() throws QueryDatabaseException {
        try (FunctionDatabase database = this.serverInfo.getFunctionDatabase(false);){
            if (!database.initialize()) {
                String errorMessage = database.getLastError().message;
                if (database.getLastError().category == FunctionDatabase.ErrorCategory.Nodatabase) {
                    errorMessage = "Database does not exist";
                }
                throw new QueryDatabaseException(errorMessage);
            }
            this.databaseInfo = database.getInfo();
            this.lshVectorFactory = database.getLSHVectorFactory();
        }
    }
}

