/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.unix;

import ghidra.pcode.emu.sys.EmuFileContents;
import ghidra.pcode.emu.unix.EmuUnixFile;
import ghidra.pcode.emu.unix.EmuUnixFileStat;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.util.MathUtilities;

public abstract class AbstractEmuUnixFile<T>
implements EmuUnixFile<T> {
    protected final String pathname;
    protected final EmuUnixFileStat stat;
    protected EmuFileContents<T> contents;

    public AbstractEmuUnixFile(String pathname, int mode) {
        this.pathname = pathname;
        this.stat = this.createStat();
        this.stat.st_mode = mode;
        this.contents = this.createDefaultContents();
    }

    protected EmuUnixFileStat createStat() {
        return new EmuUnixFileStat();
    }

    protected abstract EmuFileContents<T> createDefaultContents();

    @Override
    public String getPathname() {
        return this.pathname;
    }

    @Override
    public EmuUnixFileStat getStat() {
        return this.stat;
    }

    @Override
    public T read(PcodeArithmetic<T> arithmetic, T offset, T buf) {
        long off = arithmetic.toLong(offset, PcodeArithmetic.Purpose.OTHER);
        long len = this.contents.read(off, buf, this.stat.st_size);
        return (T)arithmetic.fromConst(len, (int)arithmetic.sizeOf(offset));
    }

    @Override
    public T write(PcodeArithmetic<T> arithmetic, T offset, T buf) {
        long off = arithmetic.toLong(offset, PcodeArithmetic.Purpose.OTHER);
        long len = this.contents.write(off, buf, this.stat.st_size);
        this.stat.st_size = MathUtilities.unsignedMax((long)this.stat.st_size, (long)(off + len));
        return (T)arithmetic.fromConst(len, (int)arithmetic.sizeOf(offset));
    }

    @Override
    public synchronized void truncate() {
        this.stat.st_size = 0L;
        this.contents.truncate();
    }
}

