/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.extlib;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.extlib.ExtLibrary;
import sarif.export.extlib.ExtLibraryLocation;
import sarif.managers.ExternalLibSarifMgr;

public class SarifClassesNamespaceWriter
extends AbstractExtWriter {
    private List<GhidraClass> classes = new ArrayList<GhidraClass>();
    private ExternalManager externalManager;
    private SymbolTable symbolTable;

    public SarifClassesNamespaceWriter(ExternalManager externalManager, SymbolTable symbolTable, List<GhidraClass> request, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.externalManager = externalManager;
        this.symbolTable = symbolTable;
        this.classes = request;
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genClasses(monitor);
        this.root.add("definedData", (JsonElement)this.objects);
    }

    private void genClasses(TaskMonitor monitor) throws CancelledException {
        monitor.initialize((long)this.classes.size());
        Iterator classNamespaces = this.symbolTable.getClassNamespaces();
        while (classNamespaces.hasNext()) {
            GhidraClass next = (GhidraClass)classNamespaces.next();
            this.walkSymbols(next);
            monitor.increment();
        }
    }

    private void walkSymbols(GhidraClass cls) {
        String clsName = cls.getName(true);
        String path = this.externalManager.getExternalLibraryPath(clsName);
        if (path == null) {
            path = "";
        }
        ExtLibrary lib = new ExtLibrary(clsName, path, SourceType.DEFAULT);
        SarifObject sarif = new SarifObject(ExternalLibSarifMgr.SUBKEY0, ExternalLibSarifMgr.KEY, this.getTree(lib), null);
        this.objects.add(this.getTree(sarif));
        if (cls.isExternal()) {
            SymbolIterator symbols = this.symbolTable.getSymbols((Namespace)cls);
            while (symbols.hasNext()) {
                Symbol sym = symbols.next();
                ExternalLocation loc = this.externalManager.getExternalLocation(sym);
                if (loc == null) continue;
                ExtLibraryLocation obj = new ExtLibraryLocation(loc);
                SarifObject sarif2 = new SarifObject(ExternalLibSarifMgr.SUBKEY1, ExternalLibSarifMgr.KEY, this.getTree(obj), loc.getAddress(), loc.getAddress());
                this.objects.add(this.getTree(sarif2));
            }
        }
    }

    public JsonArray getResults() {
        return this.objects;
    }
}

