/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.target;

import ghidra.app.services.DebuggerTargetService;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.target.TargetPublicationListener;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.trace.model.Trace;
import ghidra.util.datastruct.ListenerSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@PluginInfo(shortDescription="Debugger targets manager service", description="Maintains a collection of published targets and notifies listeners of changes.", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, servicesProvided={DebuggerTargetService.class})
public class DebuggerTargetServicePlugin
extends Plugin
implements DebuggerTargetService {
    private final Map<Trace, Target> targets = new HashMap<Trace, Target>();
    private final ListenerSet<TargetPublicationListener> listeners = new ListenerSet(TargetPublicationListener.class, true);

    public DebuggerTargetServicePlugin(PluginTool tool) {
        super(tool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishTarget(Target target) {
        boolean notify;
        Map<Trace, Target> map = this.targets;
        synchronized (map) {
            notify = this.targets.put(target.getTrace(), target) != target;
        }
        if (notify) {
            ((TargetPublicationListener)this.listeners.invoke()).targetPublished(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withdrawTarget(Target target) {
        boolean notify;
        Map<Trace, Target> map = this.targets;
        synchronized (map) {
            notify = this.targets.remove(target.getTrace()) == target;
        }
        if (notify) {
            ((TargetPublicationListener)this.listeners.invoke()).targetWithdrawn(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Target> getPublishedTargets() {
        Map<Trace, Target> map = this.targets;
        synchronized (map) {
            return List.copyOf(this.targets.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Target getTarget(Trace trace) {
        Map<Trace, Target> map = this.targets;
        synchronized (map) {
            return this.targets.get(trace);
        }
    }

    public void addTargetPublicationListener(TargetPublicationListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeTargetPublicationListener(TargetPublicationListener listener) {
        this.listeners.remove((Object)listener);
    }
}

