/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMDocument;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class DocumentTypeImpl
extends AbstractDOMNode
implements DocumentType {
    private static final long serialVersionUID = 1L;
    private final String qualifiedName;
    private final String publicId;
    private final String systemId;

    public DocumentTypeImpl(String string, String string2, String string3) {
        super((short)10);
        this.qualifiedName = string;
        this.publicId = string2;
        this.systemId = string3;
    }

    @Override
    void checkAppendNode(Node node) {
        throw new DOMException(3, "Cannot add children to this node");
    }

    @Override
    public String getBaseURI() {
        DOMDocument dOMDocument = this.getOwnerDocument();
        if (dOMDocument != null) {
            return dOMDocument.getBaseURI();
        }
        return null;
    }

    @Override
    @Deprecated
    public NamedNodeMap getEntities() {
        return null;
    }

    @Override
    @Deprecated
    public String getInternalSubset() {
        return null;
    }

    @Override
    public String getName() {
        return this.qualifiedName;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    @Deprecated
    public NamedNodeMap getNotations() {
        return null;
    }

    @Override
    public DOMDocument getOwnerDocument() {
        return (DOMDocument)this.getParentNode();
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public String lookupNamespaceURI(String string) {
        return null;
    }

    @Override
    public DocumentType cloneNode(boolean bl) {
        return new DocumentTypeImpl(this.qualifiedName, this.publicId, this.systemId);
    }

    public String toString() {
        boolean bl = this.systemId != null && this.systemId.length() != 0;
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("<!DOCTYPE ").append(this.qualifiedName);
        if (this.publicId != null && this.publicId.length() != 0) {
            stringBuilder.append(" PUBLIC \"");
            stringBuilder.append(DOMAttr.escapeAttributeEntities(this.publicId)).append('\"');
        } else if (bl) {
            stringBuilder.append(" SYSTEM");
        }
        if (bl) {
            stringBuilder.append(" \"");
            stringBuilder.append(DOMAttr.escapeAttributeEntities(this.systemId)).append('\"');
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }
}

