/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PercentageEvaluator;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.AbstractStringValue;
import io.sf.carte.echosvg.css.engine.value.CSSProxyValueException;
import io.sf.carte.echosvg.css.engine.value.CalcValue;
import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.IdentifierManager;
import io.sf.carte.echosvg.css.engine.value.MathFunctionValue;
import io.sf.carte.echosvg.css.engine.value.Messages;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import io.sf.carte.echosvg.css.engine.value.RGBColorValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.w3c.dom.DOMException;

public abstract class AbstractColorManager
extends IdentifierManager {
    protected static final StringMap values = new StringMap(50);
    protected static final StringMap computedValues;

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        int n = 7;
        switch (lexicalUnit.getLexicalUnitType()) {
            case LABCOLOR: 
            case LCHCOLOR: 
            case OKLABCOLOR: 
            case OKLCHCOLOR: 
            case COLOR_MIX: {
                String string;
                ValueFactory valueFactory = new ValueFactory();
                try {
                    StyleValue styleValue = valueFactory.createCSSValue(lexicalUnit);
                    if (styleValue.getCssValueType() != CSSValue.CssType.TYPED) {
                        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
                    }
                    CSSColor cSSColor = ((CSSColorValue)styleValue).getColor();
                    if (cSSColor.isInGamut("srgb")) {
                        cSSColor = cSSColor.toColorSpace("srgb");
                        AbstractColorManager.setComponentsMaximumFractionDigits(cSSColor, 7);
                        String string2 = cSSColor.toString();
                        lexicalUnit = this.reparseColor(string2);
                        return this.createRGBColor(lexicalUnit);
                    }
                    cSSColor = cSSColor.isInGamut("display-p3") ? cSSColor.toColorSpace("display-p3") : (cSSColor.isInGamut("a98-rgb") ? cSSColor.toColorSpace("a98-rgb") : (cSSColor.isInGamut("rec2020") ? cSSColor.toColorSpace("rec2020") : cSSColor.toColorSpace("prophoto-rgb")));
                    AbstractColorManager.setComponentsMaximumFractionDigits(cSSColor, 7);
                    string = cSSColor.toString();
                }
                catch (DOMException dOMException) {
                    throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
                }
                lexicalUnit = this.reparseColor(string);
            }
            case COLOR_FUNCTION: {
                return this.createColorFunction(lexicalUnit);
            }
            case HSLCOLOR: 
            case HWBCOLOR: {
                String string;
                ValueFactory valueFactory = new ValueFactory();
                try {
                    StyleValue styleValue = valueFactory.createCSSValue(lexicalUnit);
                    if (styleValue.getCssValueType() != CSSValue.CssType.TYPED) {
                        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
                    }
                    RGBAColor rGBAColor = ((CSSTypedValue)styleValue).toRGBColor();
                    AbstractColorManager.setComponentsMaximumFractionDigits((CSSColor)rGBAColor, 7);
                    string = rGBAColor.toString();
                }
                catch (DOMException dOMException) {
                    throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
                }
                lexicalUnit = this.reparseColor(string);
            }
            case RGBCOLOR: {
                return this.createRGBColor(lexicalUnit);
            }
            case IDENT: {
                return super.createValue(lexicalUnit, cSSEngine).clone();
            }
        }
        return super.createValue(lexicalUnit, cSSEngine);
    }

    private static void setComponentsMaximumFractionDigits(CSSColor cSSColor, int n) {
        ((NumberValue)cSSColor.item(1)).setMaximumFractionDigits(n);
        ((NumberValue)cSSColor.item(2)).setMaximumFractionDigits(n);
        ((NumberValue)cSSColor.item(3)).setMaximumFractionDigits(n);
    }

    private LexicalUnit reparseColor(String string) throws DOMException {
        CSSParser cSSParser = new CSSParser();
        try {
            return cSSParser.parsePropertyValue((Reader)new StringReader(string));
        }
        catch (CSSParseException | IOException throwable) {
            throw this.createMalformedLexicalUnitDOMException();
        }
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value.getPrimitiveType() == CSSValue.Type.IDENT) {
            String string2 = ((AbstractStringValue)value).getValue();
            Value value2 = (Value)computedValues.get(string2);
            if (value2 != null) {
                return value2;
            }
            if (values.get(string2) == null) {
                throw new IllegalStateException("Not a system-color:" + string2);
            }
            return cSSEngine.getCSSContext().getSystemColor(string2);
        }
        return super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value);
    }

    private Value createRGBColor(LexicalUnit lexicalUnit) {
        NumericValue numericValue;
        NumericValue numericValue2;
        NumericValue numericValue3;
        NumericValue numericValue4;
        LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
        boolean bl = lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.PERCENTAGE;
        boolean bl2 = false;
        try {
            numericValue4 = this.createRGBColorComponent(lexicalUnit2);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            }
            bl = bl || lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.PERCENTAGE;
            numericValue3 = this.createRGBColorComponent(lexicalUnit2);
            if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()).getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            }
            bl = bl || lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.PERCENTAGE;
            numericValue2 = this.createRGBColorComponent(lexicalUnit2);
            if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
                if ((lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA || lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_SLASH) && (lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
                    throw new DOMException(12, "Invalid color: " + lexicalUnit.getCssText());
                }
                bl2 = lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.PERCENTAGE;
                numericValue = this.createColorComponent(lexicalUnit2);
            } else {
                numericValue = null;
            }
        }
        catch (CSSProxyValueException cSSProxyValueException) {
            return this.createLexicalValue(lexicalUnit);
        }
        return this.createRGBColor(numericValue4, numericValue3, numericValue2, bl, numericValue, bl2);
    }

    protected ColorValue createRGBColor(NumericValue numericValue, NumericValue numericValue2, NumericValue numericValue3, boolean bl, NumericValue numericValue4, boolean bl2) {
        RGBColorValue rGBColorValue = numericValue4 == null ? new RGBColorValue(numericValue, numericValue2, numericValue3) : new RGBColorValue(numericValue, numericValue2, numericValue3, numericValue4);
        rGBColorValue.setSpecifiedAsPercentage(bl);
        rGBColorValue.setAlphaSpecifiedAsPercentage(bl2);
        return rGBColorValue;
    }

    /*
     * Exception decompiling
     */
    private Value createColorFunction(LexicalUnit var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 7[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected NumericValue createRGBColorComponent(LexicalUnit lexicalUnit) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case INTEGER: {
                return new FloatValue(2, (float)lexicalUnit.getIntegerValue() / 2.55f);
            }
            case REAL: {
                return new FloatValue(2, lexicalUnit.getFloatValue() / 2.55f);
            }
            case PERCENTAGE: {
                return new FloatValue(2, lexicalUnit.getFloatValue());
            }
            case VAR: 
            case ATTR: {
                throw new CSSProxyValueException();
            }
            case CALC: {
                Value value = this.createCalc(lexicalUnit);
                if (value.getCssValueType() == CSSValue.CssType.PROXY) {
                    throw new CSSProxyValueException();
                }
                if (value.getPrimitiveType() != CSSValue.Type.EXPRESSION) break;
                return this.evaluateComponentExpression((CalcValue)value);
            }
            case MATH_FUNCTION: {
                Value value;
                try {
                    value = this.createMathFunction(lexicalUnit, "<number|percentage>");
                }
                catch (Exception exception) {
                    DOMException dOMException = this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
                    dOMException.initCause(exception);
                    throw dOMException;
                }
                if (value.getCssValueType() == CSSValue.CssType.PROXY) {
                    throw new CSSProxyValueException();
                }
                if (value.getPrimitiveType() != CSSValue.Type.MATH_FUNCTION) break;
                return this.evaluateComponentFunction((MathFunctionValue)value);
            }
        }
        throw this.createInvalidRGBComponentUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    protected NumericValue createColorComponent(LexicalUnit lexicalUnit) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case INTEGER: {
                return new FloatValue(0, lexicalUnit.getIntegerValue());
            }
            case REAL: {
                return new FloatValue(0, lexicalUnit.getFloatValue());
            }
            case PERCENTAGE: {
                return new FloatValue(2, lexicalUnit.getFloatValue());
            }
            case VAR: 
            case ATTR: {
                throw new CSSProxyValueException();
            }
            case CALC: {
                Value value = this.createCalc(lexicalUnit);
                if (value.getCssValueType() == CSSValue.CssType.PROXY) {
                    throw new CSSProxyValueException();
                }
                if (value.getPrimitiveType() != CSSValue.Type.EXPRESSION) break;
                return this.evaluateComponentExpression((CalcValue)value);
            }
            case MATH_FUNCTION: {
                Value value;
                try {
                    value = this.createMathFunction(lexicalUnit, "<number|percentage>");
                }
                catch (Exception exception) {
                    DOMException dOMException = this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
                    dOMException.initCause(exception);
                    throw dOMException;
                }
                if (value.getCssValueType() == CSSValue.CssType.PROXY) {
                    throw new CSSProxyValueException();
                }
                if (value.getPrimitiveType() != CSSValue.Type.MATH_FUNCTION) break;
                return this.evaluateComponentFunction((MathFunctionValue)value);
            }
        }
        throw this.createInvalidComponentUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    private FloatValue evaluateComponentExpression(CalcValue calcValue) {
        PercentageEvaluator percentageEvaluator = new PercentageEvaluator();
        CSSTypedValue cSSTypedValue = percentageEvaluator.evaluateExpression((CSSExpressionValue)calcValue.getNumericDelegate());
        return new FloatValue(0, cSSTypedValue.getFloatValue((short)0));
    }

    private FloatValue evaluateComponentFunction(MathFunctionValue mathFunctionValue) {
        PercentageEvaluator percentageEvaluator = new PercentageEvaluator();
        CSSNumberValue cSSNumberValue = percentageEvaluator.evaluateFunction((CSSMathFunctionValue)mathFunctionValue.getNumericDelegate());
        return new FloatValue(0, cSSNumberValue.getFloatValue((short)0));
    }

    @Override
    public StringMap getIdentifiers() {
        return values;
    }

    private DOMException createInvalidRGBComponentUnitDOMException(LexicalUnit.LexicalType lexicalType) {
        Object[] objectArray = new Object[]{this.getPropertyName(), lexicalType.toString()};
        String string = Messages.formatMessage("invalid.rgb.component.unit", objectArray);
        return new DOMException(9, string);
    }

    private DOMException createInvalidComponentUnitDOMException(LexicalUnit.LexicalType lexicalType) {
        Object[] objectArray = new Object[]{this.getPropertyName(), lexicalType.toString()};
        String string = Messages.formatMessage("invalid.color.component.unit", objectArray);
        return new DOMException(9, string);
    }

    static {
        values.put("aqua", ValueConstants.AQUA_VALUE);
        values.put("black", ValueConstants.BLACK_VALUE);
        values.put("blue", ValueConstants.BLUE_VALUE);
        values.put("fuchsia", ValueConstants.FUCHSIA_VALUE);
        values.put("gray", ValueConstants.GRAY_VALUE);
        values.put("green", ValueConstants.GREEN_VALUE);
        values.put("lime", ValueConstants.LIME_VALUE);
        values.put("maroon", ValueConstants.MAROON_VALUE);
        values.put("navy", ValueConstants.NAVY_VALUE);
        values.put("olive", ValueConstants.OLIVE_VALUE);
        values.put("purple", ValueConstants.PURPLE_VALUE);
        values.put("red", ValueConstants.RED_VALUE);
        values.put("silver", ValueConstants.SILVER_VALUE);
        values.put("teal", ValueConstants.TEAL_VALUE);
        values.put("transparent", ValueConstants.TRANSPARENT_VALUE);
        values.put("white", ValueConstants.WHITE_VALUE);
        values.put("yellow", ValueConstants.YELLOW_VALUE);
        values.put("activeborder", ValueConstants.ACTIVEBORDER_VALUE);
        values.put("activecaption", ValueConstants.ACTIVECAPTION_VALUE);
        values.put("appworkspace", ValueConstants.APPWORKSPACE_VALUE);
        values.put("background", ValueConstants.BACKGROUND_VALUE);
        values.put("buttonface", ValueConstants.BUTTONFACE_VALUE);
        values.put("buttonhighlight", ValueConstants.BUTTONHIGHLIGHT_VALUE);
        values.put("buttonshadow", ValueConstants.BUTTONSHADOW_VALUE);
        values.put("buttontext", ValueConstants.BUTTONTEXT_VALUE);
        values.put("captiontext", ValueConstants.CAPTIONTEXT_VALUE);
        values.put("graytext", ValueConstants.GRAYTEXT_VALUE);
        values.put("highlight", ValueConstants.HIGHLIGHT_VALUE);
        values.put("highlighttext", ValueConstants.HIGHLIGHTTEXT_VALUE);
        values.put("inactiveborder", ValueConstants.INACTIVEBORDER_VALUE);
        values.put("inactivecaption", ValueConstants.INACTIVECAPTION_VALUE);
        values.put("inactivecaptiontext", ValueConstants.INACTIVECAPTIONTEXT_VALUE);
        values.put("infobackground", ValueConstants.INFOBACKGROUND_VALUE);
        values.put("infotext", ValueConstants.INFOTEXT_VALUE);
        values.put("menu", ValueConstants.MENU_VALUE);
        values.put("menutext", ValueConstants.MENUTEXT_VALUE);
        values.put("scrollbar", ValueConstants.SCROLLBAR_VALUE);
        values.put("threeddarkshadow", ValueConstants.THREEDDARKSHADOW_VALUE);
        values.put("threedface", ValueConstants.THREEDFACE_VALUE);
        values.put("threedhighlight", ValueConstants.THREEDHIGHLIGHT_VALUE);
        values.put("threedlightshadow", ValueConstants.THREEDLIGHTSHADOW_VALUE);
        values.put("threedshadow", ValueConstants.THREEDSHADOW_VALUE);
        values.put("window", ValueConstants.WINDOW_VALUE);
        values.put("windowframe", ValueConstants.WINDOWFRAME_VALUE);
        values.put("windowtext", ValueConstants.WINDOWTEXT_VALUE);
        computedValues = new StringMap(18);
        computedValues.put("black", ValueConstants.BLACK_RGB_VALUE);
        computedValues.put("silver", ValueConstants.SILVER_RGB_VALUE);
        computedValues.put("gray", ValueConstants.GRAY_RGB_VALUE);
        computedValues.put("white", ValueConstants.WHITE_RGB_VALUE);
        computedValues.put("maroon", ValueConstants.MAROON_RGB_VALUE);
        computedValues.put("red", ValueConstants.RED_RGB_VALUE);
        computedValues.put("purple", ValueConstants.PURPLE_RGB_VALUE);
        computedValues.put("fuchsia", ValueConstants.FUCHSIA_RGB_VALUE);
        computedValues.put("green", ValueConstants.GREEN_RGB_VALUE);
        computedValues.put("lime", ValueConstants.LIME_RGB_VALUE);
        computedValues.put("olive", ValueConstants.OLIVE_RGB_VALUE);
        computedValues.put("yellow", ValueConstants.YELLOW_RGB_VALUE);
        computedValues.put("navy", ValueConstants.NAVY_RGB_VALUE);
        computedValues.put("blue", ValueConstants.BLUE_RGB_VALUE);
        computedValues.put("teal", ValueConstants.TEAL_RGB_VALUE);
        computedValues.put("aqua", ValueConstants.AQUA_RGB_VALUE);
        computedValues.put("transparent", ValueConstants.TRANSPARENT_RGB_VALUE);
    }
}

