/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridCharset;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CubridCollation
implements DBSObject {
    private String name;
    private CubridCharset charset;
    private CubridDataSource dataSource;

    protected CubridCollation(@NotNull String name) {
        this.name = name;
    }

    protected CubridCollation(@NotNull CubridCharset charset, @NotNull ResultSet dbResult) throws SQLException {
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"collation");
        this.charset = charset;
        this.dataSource = charset.getDataSource();
    }

    @NotNull
    public CubridDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public CubridCharset getCharset() {
        return this.charset;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @NotNull
    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public DBSObject getParentObject() {
        return this.dataSource;
    }
}

