/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.AssignmentOrigin;
import org.sat4j.specs.Constr;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;
import org.sat4j.specs.UnitClauseConsumer;
import org.sat4j.specs.UnitClauseProvider;

public class ObjectiveReducerPBSolverDecorator
implements IPBSolver {
    private static final long serialVersionUID = -1637773414229087105L;
    private final IPBSolver decorated;
    private final List<IVecInt> atMostOneCstrs = new ArrayList<IVecInt>();

    public ObjectiveReducerPBSolverDecorator(IPBSolver decorated) {
        this.decorated = decorated;
    }

    public int[] model() {
        return this.decorated.model();
    }

    public int newVar() {
        return this.decorated.newVar();
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt lits, IVec<BigInteger> coeffs, boolean moreThan, BigInteger d) throws ContradictionException {
        return this.decorated.addPseudoBoolean(lits, coeffs, moreThan, d);
    }

    public boolean model(int var) {
        return this.decorated.model(var);
    }

    public int nextFreeVarId(boolean reserve) {
        return this.decorated.nextFreeVarId(reserve);
    }

    public int[] primeImplicant() {
        return this.decorated.primeImplicant();
    }

    public boolean primeImplicant(int p) {
        return this.decorated.primeImplicant(p);
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        IteratorInt it = coeffs.iterator();
        while (it.hasNext()) {
            if (it.next() == degree) continue;
            return this.decorated.addAtMost(literals, coeffs, degree);
        }
        this.atMostOneCstrs.add(literals);
        return this.decorated.addAtMost(literals, coeffs, degree);
    }

    public boolean isSatisfiable() throws TimeoutException {
        return this.decorated.isSatisfiable();
    }

    public boolean isSatisfiable(IVecInt assumps, boolean globalTimeout) throws TimeoutException {
        return this.decorated.isSatisfiable(assumps, globalTimeout);
    }

    public void registerLiteral(int p) {
        this.decorated.registerLiteral(p);
    }

    public void setExpectedNumberOfClauses(int nb) {
        this.decorated.setExpectedNumberOfClauses(nb);
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        Iterator it = coeffs.iterator();
        while (it.hasNext()) {
            if (((BigInteger)it.next()).equals(degree)) continue;
            return this.decorated.addAtMost(literals, coeffs, degree);
        }
        this.atMostOneCstrs.add(literals);
        return this.decorated.addAtMost(literals, coeffs, degree);
    }

    public boolean isSatisfiable(boolean globalTimeout) throws TimeoutException {
        return this.decorated.isSatisfiable(globalTimeout);
    }

    public IConstr addClause(IVecInt literals) throws ContradictionException {
        return this.decorated.addClause(literals);
    }

    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        return this.decorated.isSatisfiable(assumps);
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        return this.decorated.addAtLeast(literals, coeffs, degree);
    }

    public int[] findModel() throws TimeoutException {
        return this.decorated.findModel();
    }

    public IConstr addBlockingClause(IVecInt literals) throws ContradictionException {
        return this.decorated.addBlockingClause(literals);
    }

    public IConstr discardCurrentModel() throws ContradictionException {
        return this.decorated.discardCurrentModel();
    }

    public IVecInt createBlockingClauseForCurrentModel() {
        return this.decorated.createBlockingClauseForCurrentModel();
    }

    public boolean removeConstr(IConstr c) {
        return this.decorated.removeConstr(c);
    }

    public int[] findModel(IVecInt assumps) throws TimeoutException {
        return this.decorated.findModel(assumps);
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        return this.decorated.addAtLeast(literals, coeffs, degree);
    }

    public boolean removeSubsumedConstr(IConstr c) {
        return this.decorated.removeSubsumedConstr(c);
    }

    public int nConstraints() {
        return this.decorated.nConstraints();
    }

    public int newVar(int howmany) {
        return this.decorated.newVar(howmany);
    }

    public void addAllClauses(IVec<IVecInt> clauses) throws ContradictionException {
        Iterator it = clauses.iterator();
        while (it.hasNext()) {
            this.addClause((IVecInt)it.next());
        }
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVecInt coeffs, int weight) throws ContradictionException {
        return this.decorated.addExactly(literals, coeffs, weight);
    }

    public int nVars() {
        return this.decorated.nVars();
    }

    public void printInfos(PrintWriter out, String prefix) {
        this.decorated.printInfos(out, prefix);
    }

    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        if (degree == 1) {
            this.atMostOneCstrs.add(literals);
        }
        return this.decorated.addAtMost(literals, degree);
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVec<BigInteger> coeffs, BigInteger weight) throws ContradictionException {
        return this.decorated.addExactly(literals, coeffs, weight);
    }

    public void printInfos(PrintWriter out) {
        this.decorated.printInfos(out);
    }

    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        return this.decorated.addAtLeast(literals, degree);
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction obj) {
        if (obj != null) {
            VecInt newVars = new VecInt();
            Vec newCoeffs = new Vec();
            HashSet<Integer> oldVarsToIgnore = new HashSet<Integer>();
            IVecInt oldObjVars = obj.getVars();
            IVec<BigInteger> oldObjCoeffs = obj.getCoeffs();
            int nbReduc = this.processAtMostOneCstrs(obj, (IVecInt)newVars, (IVec<BigInteger>)newCoeffs, oldVarsToIgnore);
            System.out.println("c " + nbReduc + " reductions due to atMostOne constraints");
            for (int i = 0; i < oldObjVars.size(); ++i) {
                if (oldVarsToIgnore.contains(oldObjVars.get(i))) continue;
                newVars.push(oldObjVars.get(i));
                newCoeffs.push(oldObjCoeffs.get(i));
            }
            obj = new ObjectiveFunction((IVecInt)newVars, (IVec<BigInteger>)newCoeffs);
        }
        this.decorated.setObjectiveFunction(obj);
    }

    private int processAtMostOneCstrs(ObjectiveFunction obj, IVecInt newVars, IVec<BigInteger> newCoeffs, Set<Integer> oldVarsToIgnore) {
        System.out.println("c " + this.atMostOneCstrs.size() + " atMostOne constraints found");
        int nbReduc = 0;
        IVecInt oldObjVars = obj.getVars();
        IVec<BigInteger> oldObjCoeffs = obj.getCoeffs();
        for (IVecInt lits : this.atMostOneCstrs) {
            boolean allLitsIn = true;
            for (int next : lits) {
                if (oldVarsToIgnore.contains(next)) {
                    allLitsIn = false;
                    break;
                }
                int indexOf = oldObjVars.indexOf(next);
                if (indexOf != -1 && ((BigInteger)oldObjCoeffs.get(indexOf)).equals(BigInteger.ONE)) continue;
                allLitsIn = false;
                break;
            }
            if (!allLitsIn) continue;
            int newObjVar = this.nextFreeVarId(true);
            try {
                for (int nextInt : lits) {
                    this.decorated.addClause((IVecInt)new VecInt(new int[]{nextInt, newObjVar}));
                    oldVarsToIgnore.add(nextInt);
                    ++nbReduc;
                }
            }
            catch (ContradictionException e) {
                Logger.getLogger("org.sat4j.pb").log(Level.SEVERE, "Inconsistency found, should not happen", e);
            }
            newVars.push(newObjVar);
            newCoeffs.push((Object)BigInteger.ONE);
            --nbReduc;
        }
        return nbReduc;
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.decorated.getObjectiveFunction();
    }

    public IConstr addExactly(IVecInt literals, int n) throws ContradictionException {
        return this.decorated.addExactly(literals, n);
    }

    public void setTimeout(int t) {
        this.decorated.setTimeout(t);
    }

    public void setTimeoutOnConflicts(int count) {
        this.decorated.setTimeoutOnConflicts(count);
    }

    public void setTimeoutMs(long t) {
        this.decorated.setTimeoutMs(t);
    }

    public int getTimeout() {
        return this.decorated.getTimeout();
    }

    public long getTimeoutMs() {
        return this.decorated.getTimeoutMs();
    }

    public void expireTimeout() {
        this.decorated.expireTimeout();
    }

    public void reset() {
        this.decorated.reset();
    }

    public void printStat(PrintStream out, String prefix) {
        this.decorated.printStat(out, prefix);
    }

    public void printStat(PrintWriter out, String prefix) {
        this.decorated.printStat(out, prefix);
    }

    public void printStat(PrintWriter out) {
        this.decorated.printStat(out);
    }

    public Map<String, Number> getStat() {
        return this.decorated.getStat();
    }

    public String toString(String prefix) {
        return this.decorated.toString(prefix);
    }

    public void clearLearntClauses() {
        this.decorated.clearLearntClauses();
    }

    public void setDBSimplificationAllowed(boolean status) {
        this.decorated.setDBSimplificationAllowed(status);
    }

    public boolean isDBSimplificationAllowed() {
        return this.decorated.isDBSimplificationAllowed();
    }

    public <S extends ISolverService> void setSearchListener(SearchListener<S> sl) {
        this.decorated.setSearchListener(sl);
    }

    public <S extends ISolverService> SearchListener<S> getSearchListener() {
        return this.decorated.getSearchListener();
    }

    public boolean isVerbose() {
        return this.decorated.isVerbose();
    }

    public void setVerbose(boolean value) {
        this.decorated.setVerbose(value);
    }

    public void setLogPrefix(String prefix) {
        this.decorated.setLogPrefix(prefix);
    }

    public String getLogPrefix() {
        return this.decorated.getLogPrefix();
    }

    public IVecInt unsatExplanation() {
        return this.decorated.unsatExplanation();
    }

    public int[] modelWithInternalVariables() {
        return this.decorated.modelWithInternalVariables();
    }

    public int realNumberOfVariables() {
        return this.decorated.realNumberOfVariables();
    }

    public boolean isSolverKeptHot() {
        return this.decorated.isSolverKeptHot();
    }

    public void setKeepSolverHot(boolean keepHot) {
        this.decorated.setKeepSolverHot(keepHot);
    }

    public ISolver getSolvingEngine() {
        return this.decorated.getSolvingEngine();
    }

    public void setUnitClauseProvider(UnitClauseProvider ucp) {
        this.decorated.setUnitClauseProvider(ucp);
    }

    public IConstr addConstr(Constr constr) {
        return this.decorated.addConstr(constr);
    }

    public IConstr addParity(IVecInt literals, boolean even) {
        return this.decorated.addParity(literals, even);
    }

    public AssignmentOrigin getOriginInModel(int p) {
        return this.decorated.getOriginInModel(p);
    }

    public void setUnitClauseConsumer(UnitClauseConsumer ucc) {
        this.decorated.setUnitClauseConsumer(ucc);
    }
}

