/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.hints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDResultSetModel;
import org.jkiss.dbeaver.model.data.DBDValueRow;
import org.jkiss.dbeaver.model.data.hints.DBDCellHintProvider;
import org.jkiss.dbeaver.model.data.hints.DBDValueHint;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.ui.data.hints.ValueHintReference;
import org.jkiss.utils.CommonUtils;

public class ReferenceCellHintProvider
implements DBDCellHintProvider {
    @Nullable
    public DBDValueHint[] getCellHints(@NotNull DBDResultSetModel model, @NotNull DBDAttributeBinding attribute, @NotNull DBDValueRow row, @Nullable Object value, @NotNull EnumSet<DBDValueHint.HintType> types, int options) {
        if (DBUtils.isNullValue((Object)value)) {
            return null;
        }
        List referrers = attribute.getReferrers();
        if (!CommonUtils.isEmpty((Collection)referrers)) {
            ArrayList<ValueHintReference> refHints = new ArrayList<ValueHintReference>();
            for (DBSEntityReferrer referrer : referrers) {
                DBSEntityConstraint refConstr;
                DBSEntityAssociation ea;
                if (!(referrer instanceof DBSEntityAssociation) || this.isTableReferenceExists(ea = (DBSEntityAssociation)referrer, refHints) || (refConstr = ea.getReferencedConstraint()) == null) continue;
                refHints.add(new ValueHintReference(attribute, row, ea));
            }
            return refHints.toArray(new DBDValueHint[0]);
        }
        return null;
    }

    private boolean isTableReferenceExists(DBSEntityAssociation assoc, List<ValueHintReference> hints) {
        for (ValueHintReference hr : hints) {
            if (assoc.getAssociatedEntity() != hr.getAssociation().getAssociatedEntity()) continue;
            return true;
        }
        return false;
    }
}

